/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SecureConnectionRequiredException.java,v 1.4 2005/02/16 22:20:18 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.security;

import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class SecureConnectionRequiredException
	extends AgentControllerUnavailableException {
		
		ServerSecurityInfoCommand _details;
		
		public SecureConnectionRequiredException(ServerSecurityInfoCommand command) {
			_details=command;
		}
		
		public boolean isPasswordProtected() {
			return _details.isPasswordProtected();
		}
		
		public boolean isClientAuthenticationRequired() {
			return _details.isClientAuthenticationRequired();
		}
		
		public long getSecurePort() {
			return _details.getSecurePort();	
		}

}
