/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolIteratorSequentialShared.java,v 1.5 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Dec 3, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.datapool.iterator;

import org.eclipse.hyades.execution.runtime.datapool.*;

/**
 * @author ahoppe
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 *
 */

public class DatapoolIteratorSequentialShared
             extends org.eclipse.hyades.datapool.iterator.DatapoolIteratorImpl_Base
             implements org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator 
{

    private static DatapoolIteratorSequentialShared instance = null;
    private static int instanceCount = 0;
    
    
    public DatapoolIteratorSequentialShared()
    {
		currentEquivClassIndex =0;
		currentRecordIndex = -1;
		
    }
 	
 	public static DatapoolIteratorSequentialShared getInstance()
 	{
 		synchronized(DatapoolIteratorSequentialShared.class)
 		{
		    if (instance == null)
		    {
			    instance = new DatapoolIteratorSequentialShared();
		    }
 		    instanceCount++;
 		}		
		return instance;
 	}
 	
 	
	public static synchronized void close() 
	{
		synchronized(DatapoolIteratorSequentialShared.class)
		{
			instanceCount--;
		    if (instanceCount == 0)
		    {
			    instance = null;
		    }
		}
    }

	/**
	 * Initialize the iterator sequence from the specified datapool object.
	 * Depending on the implementation of this method the iterator may use
	 * sequential or random access order, share a cursor with other processes
	 * or use a repeating sequence to access the records.  The order of access
	 * is left to the individual iterator implementations.
	 * 
	 * @param	datapool	The datapool to iterate over.
	 * @param	equivalenceClassIndex	The zero-based index of the equivalence
	 *						class that should be iterated over.  If this value
	 *						is negative then all records in the datapool should be
	 *						will be available to the iterator.
	 */
	public void dpInitialize(IDatapool datapool, int equivalenceClassIndex)
	{
		synchronized(this) {
		    myDatapool = datapool;				
		    allEquivClasses = (equivalenceClassIndex < 0);
		    /*
		    if(allEquivClasses)
		        currentEquivClassIndex = 0;
		    else
		        currentEquivClassIndex = equivalenceClassIndex;
		    currentRecordIndex = 0;
		    */
		    if (!allEquivClasses)
		        currentEquivClassIndex=equivalenceClassIndex;
		    this.dpNext();
		    done = this.dpDone();
		}				
	}

	/**
	 * This method acts the same way as {@link #dpInitialize(IDatapool,int) dpInitialize with equivalence class specification}
	 * except that {@link IDatapool#getDefaultEquivalenceClassIndex() default} 
	 * equivalence class is used.
	 * 
	 * @param	datapool	The datapool to iterate over.
	 */
	public void dpInitialize(IDatapool datapool)
	{
		this.dpInitialize(datapool, datapool.getDefaultEquivalenceClassIndex());
	}
	

	/**
	 * Returns <code>true</code> if the {@link #dpCurrent() current} iterator
	 * value is <code>null</code>.
	 * 
	 * @see	#dpCurrent()
	 * @see #dpNext()
	 * @see #dpReset()
	 */
	public boolean dpDone()
	{
		if (!allEquivClasses)
		    return (currentRecordIndex == 
		    myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount());
		else
		    return (
		      (currentEquivClassIndex == myDatapool.getEquivalenceClassCount())
		      && 
		      (currentRecordIndex == 0)
		    );
		    
	}

	/**
	 * Increments the iterator associated with an instance of the datapool.
	 * Calling this method after the iteration sequence has been exhausted has no
	 * effect.
	 * 
	 * @see	#dpCurrent()
	 * @see #dpDone()
	 * @see #dpReset()
	 */
	public void dpNext()
	{
		synchronized(this) {
			if (this.done)
			    return;
	        if (!allEquivClasses)
	        {
	    	    if(currentRecordIndex < 
	    	    myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount())
	    	       currentRecordIndex++;				    	
	        }
	        else 
	        {
	    	    if (currentEquivClassIndex < myDatapool.getEquivalenceClassCount())
			        if(currentRecordIndex < 
		               myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount()-1)
		                currentRecordIndex++;
		            else
		            {
		        	    currentEquivClassIndex++;
		        	    currentRecordIndex = 0;	
		            }
	        }
	        this.done = this.dpDone();
	    }
	}

	/**
	 * Restart the iterator associated with an instance of the datapool.
	 * It does not matter if the iterator has been exhausted of entries or
	 * not, the iterator simply resets to the initial start state.
	 * 
	 * @see	#dpCurrent()
	 * @see #dpDone()
	 * @see #dpNext()
	 */
	public void dpReset()
	{
		synchronized(this) {
		    if(allEquivClasses)
		        this.dpInitialize(myDatapool, -1);
		    else
		        this.dpInitialize(myDatapool, currentEquivClassIndex);
	    }
	}
	
}
