/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBVisitor.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
/**
 * A DBVisitor allows you to access referenced objects in a database,
 * controlling the number of objects that are in memory. It makes calls to a
 * Database object to access referenced objects.
 */
public interface DBVisitor {
	/**
	 * Returns a single EObject (or null) for single-valued references. Returns
	 * a PagingList for multi-valued references.
	 * 
	 * @param object
	 * @param reference
	 * @return An EObject, null, or a PagingList.
	 */
	Object get(EObject object, EReference reference);

	/**
	 * The paging size determines how many objects a paging list keeps in
	 * memory. This value will be the paging size for PagingLists returned by
	 * this DBVisitor.
	 * 
	 * @param size
	 */
	void setPagingSize(int size);

	/**
	 * Returns the paging size.
	 * 
	 * @return The paging size
	 */
	int getPagingSize();

	/**
	 * Sets the database object that is used to retrieve objects from the
	 * database.
	 * 
	 * @param database
	 */
	void setDatabase(Database database);

	/**
	 * Gets the database object that is used to retrieve objects from the
	 * database.
	 * 
	 * @return The database object
	 */
	Database getDatabase();
} // DBVisitor
