/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatabasePlugin.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.resources.database.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IPluginDescriptor;

public class DatabasePlugin extends org.eclipse.core.runtime.Plugin {
	private static DatabasePlugin inst;
	private static ResourceBundle resourceBundle = null;

	public DatabasePlugin(IPluginDescriptor descriptor) {
		super(descriptor);

		if (inst == null)
			inst = this;

		if (resourceBundle == null) {
			try {
				resourceBundle = getDescriptor().getResourceBundle();
			} catch (MissingResourceException e) {
				//e.printStackTrace();
			}
		}
	}
	public static DatabasePlugin getDefault() {
		return inst;
	}

	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	public static String getResourceString(String key) {
		if (resourceBundle == null)
			return key;

		ResourceBundle bundle = DatabasePlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * @generated
	 */
	protected static DatabasePlugin getDefaultGen() {

		return inst;
	}
	/**
	 * @generated
	 */
	protected ResourceBundle getResourceBundleGen() {

		return resourceBundle;
	}
}

