/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InternalDatabase.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;
/**
 * This interface is used by the classes in the impl package; clients of the
 * database plugin are not expected to use these methods.
 */
public interface InternalDatabase extends Database {

	/**
	 * Sets the reference for the given source object, target object, reference,
	 * and position. If the reference is single-valued, the position parameter
	 * is ignored.
	 */
	boolean setReference(EObject source, EReference reference, EObject target, int position) throws Exception;

	void update(Notification notification) throws Exception;

	/**
	 * This method returns the number of referenced objects for the given object
	 * and many-valued reference. It returns -1 if the object is not in the
	 * database.
	 * 
	 * @param object
	 *            The object that owns the reference.
	 * @param reference
	 *            A many-valued reference.
	 * @return The number of referenced objects, or -1 if the given object is
	 *         not in the database.
	 */
	int count(EObject object, EReference reference) throws Exception;

	/**
	 * This method returns true if the given referenced object is in the
	 * reference list for the given object and reference, false if not.
	 */
	boolean contains(EObject object, EReference reference, EObject referencedObject) throws Exception;

	/**
	 * This method returns the index of the given referenced object for the
	 * given object and reference.
	 */
	int indexOf(EObject object, EReference reference, EObject referencedObject) throws Exception;

	/**
	 * This method returns the last index of the given referenced object for the
	 * given object and reference.
	 */
	int lastIndexOf(EObject object, EReference reference, EObject referencedObject) throws Exception;

	/**
	 * This method updates the attribute value in the database to the current
	 * value of the attribute.
	 */
	void set(EObject object, EAttribute attribute) throws Exception;

	/**
	 * @return
	 */
	WeakObjectCache getObjectCache();

	/**
	 * Updates a reference with a list of indexes from the values list.
	 */
	void setReference(Integer sourceId, EReference reference, List targetIds, List indexes) throws Exception ;
} // InternalDatabase
