/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceAddedException.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.emf.common.util.URI;
/**
 * This exception is thrown if a resource is already in the database and you
 * attempt to add it again.
 */
public class ResourceAddedException extends Exception {
	protected URI uri;

	/**
	 * Constructor for ResourceAddedException.
	 */
	public ResourceAddedException(URI uri) {
		super();
		this.uri = uri;
	}

	/**
	 * The URI of the resource that was already added.
	 */
	public URI getURI() {
		return uri;
	}
} // ResourceAddedException
