/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceNotFoundException.java,v 1.5 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.emf.common.util.URI;
/**
 * This exception is thrown if you get a resource but the resource with the
 * given URI is not in the database.
 */
public class ResourceNotFoundException extends Exception {
	protected URI uri;

	/**
	 * Constructor for ResourceNotFoundException.
	 */
	public ResourceNotFoundException(URI uri) {
		super("ResourceNotFoundException: "+uri.toString());
		this.uri = uri;
	}

	/**
	 * The URI of the resource that was not found.
	 */
	public URI getURI() {
		return uri;
	}
} // ResourceNotFoundException
