/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Database.java,v 1.4 2005/02/16 22:21:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel;

import org.eclipse.emf.common.util.EList;
/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Database</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Database#getTables <em>Tables</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Database#getTypes <em>Types</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getDatabase()
 * @model
 * @generated
 */
public interface Database extends DBElement {
	/**

	 * Returns the value of the '<em><b>Tables</b></em>' containment reference list.

	 * The list contents are of type {@link org.eclipse.hyades.resources.database.internal.dbmodel.Table}.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Tables</em>' containment reference list isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Tables</em>' containment reference list.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getDatabase_Tables()

	 * @model type="org.eclipse.hyades.resources.database.internal.dbmodel.Table" containment="true"

	 * @generated

	 */

	EList getTables();

	/**

	 * Returns the value of the '<em><b>Types</b></em>' containment reference list.

	 * The list contents are of type {@link org.eclipse.hyades.resources.database.internal.dbmodel.SQLType}.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Types</em>' containment reference list isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Types</em>' containment reference list.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getDatabase_Types()

	 * @model type="org.eclipse.hyades.resources.database.internal.dbmodel.SQLType" containment="true"

	 * @generated

	 */

	EList getTypes();

} // Database

