/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StringTypeImpl.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.StringType;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>String Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.StringTypeImpl#getLength <em>Length</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class StringTypeImpl extends SQLTypeImpl implements StringType {
	/**

	 * The default value of the '{@link #getLength() <em>Length</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getLength()

	 * @generated

	 * @ordered

	 */

	protected static final int LENGTH_EDEFAULT = 0;

	/**

	 * The cached value of the '{@link #getLength() <em>Length</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getLength()

	 * @generated

	 * @ordered

	 */

	protected int length = LENGTH_EDEFAULT;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected StringTypeImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected EClass eStaticClass() {
		return DbmodelPackage.eINSTANCE.getStringType();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public int getLength() {
		return length;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void setLength(int newLength) {
		int oldLength = length;

		length = newLength;

		if (eNotificationRequired())

			eNotify(new ENotificationImpl(this, Notification.SET, DbmodelPackage.STRING_TYPE__LENGTH, oldLength, length));

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.STRING_TYPE__NAME :

				return getName();

			case DbmodelPackage.STRING_TYPE__SQL_TYPE :

				return new Integer(getSqlType());

			case DbmodelPackage.STRING_TYPE__LENGTH :

				return new Integer(getLength());

		}

		return eDynamicGet(eFeature, resolve);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.STRING_TYPE__NAME :

				setName((String) newValue);

				return;

			case DbmodelPackage.STRING_TYPE__SQL_TYPE :

				setSqlType(((Integer) newValue).intValue());

				return;

			case DbmodelPackage.STRING_TYPE__LENGTH :

				setLength(((Integer) newValue).intValue());

				return;

		}

		eDynamicSet(eFeature, newValue);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.STRING_TYPE__NAME :

				setName(NAME_EDEFAULT);

				return;

			case DbmodelPackage.STRING_TYPE__SQL_TYPE :

				setSqlType(SQL_TYPE_EDEFAULT);

				return;

			case DbmodelPackage.STRING_TYPE__LENGTH :

				setLength(LENGTH_EDEFAULT);

				return;

		}

		eDynamicUnset(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.STRING_TYPE__NAME :

				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);

			case DbmodelPackage.STRING_TYPE__SQL_TYPE :

				return sqlType != SQL_TYPE_EDEFAULT;

			case DbmodelPackage.STRING_TYPE__LENGTH :

				return length != LENGTH_EDEFAULT;

		}

		return eDynamicIsSet(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());

		result.append(" (maxSQLLength: ");

		result.append(length);

		result.append(')');

		return result.toString();

	}

} //StringTypeImpl

