/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatabaseType.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.extensions;
/**
 * This class represents an enumeration of the valid types of databases you can
 * work with.
 */
public class DatabaseType {
	protected int maxSQLLength;
	protected int varcharMaxSize;
	/**
	 * This class cannot be instantiated; access instances using the fields.
	 */
	public DatabaseType() {
		this.maxSQLLength = 4098;
		this.varcharMaxSize = 255;
	}
	/**
	 * Returns the maximum maxSQLLength of SQL statements for the database.
	 */
	public int getMaximumSQLLength() {
		return maxSQLLength;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return this.getClass().toString();
	}
	/**
	 * @return
	 */
	public boolean isOrderRequired() {
		return false;
	}
	/**
	 * @return
	 */
	public int getVarcharMaxSize() {
		return varcharMaxSize;
	}
	/**
	 * @return
	 */
	public boolean getAddQuotes() {
		return false;
	}
	/**
	 * @return the DEFAULT string
	 */
	public String getDefaultString() {
		return "DEFAULT";
	}
	/**
	 * @return
	 */
	public String getTableSpaceString() {
		return "";
	}
} // DatabaseType
