/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddResourceCommand.java,v 1.6 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class adds rows in the Resource table for each top level object in the
 * resource.
 */
public class AddResourceCommand extends DBCommand {
	protected Resource resource;
	protected WeakObjectCache cache;
	protected PreparedStatement prepared;

	public AddResourceCommand(JDBCHelper helper, DBMap map, Resource resource, WeakObjectCache cache) {
		super(helper,map);
		this.resource = resource;
		this.cache = cache;
	}

	public Object execute() throws Exception {
		Table resourceTable = dbMap.getResourceTable();
		createPreparedStatement(resourceTable);
		List objects = resource.getContents();
		String uri = resource.getURI().toString();

		for (int i = 0, l = objects.size(); i < l; i++) {
			EObject object = (EObject) objects.get(i);
			int id = (cache.getId(object)).intValue();
			insertRow(uri, getTableName(object), id);
		}
		if(prepared!=null)
			prepared.close();
		return null;
	}

	protected void createPreparedStatement(Table table) throws Exception {
		StatementFactory factory = StatementFactory.INSTANCE;
		SQLStatement statement = factory.createInsertStatement(dbType,table, table.getColumns());
		prepared = helper.createPreparedStatement(statement.getStatement());
	}

	protected String getTableName(EObject object) {
		EClass cls = object.eClass();
		DBMap.ClassData data = (DBMap.ClassData) dbMap.getDBRepresentation(cls);
		return data.getTable().getName();
	}

	protected void insertRow(String uri, String tableName, int id) throws Exception {
		prepared.setString(1, uri);
		prepared.setString(2, tableName);
		prepared.setInt(3, id);
		helper.executePreparedStatement(prepared);
	}
} // AddResourceCommand
