/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AttributeQuery.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This statement gets all of the attribute values for the given objects with
 * the given ids.
 */
public class AttributeQuery extends QueryStatement {
	protected int[] ids;
	protected String id, value, order;

	public AttributeQuery(int[] ids, EAttribute attribute, DBMap map, DatabaseType dbType) {
		super(dbType, map, attribute);
		this.ids = ids;
		DBMap.AttributeData data = (DBMap.AttributeData) dbMap.getDBRepresentation(attribute);
		id = data.getIdColumn().getName();
		value = data.getValueColumn().getName();
		order = data.getOrderColumn().getName();
	}

	protected void createSelectFrom() {
		statement.append("SELECT ");
		statement.append(addQuotes(id));
		statement.append(", ");
		statement.append(addQuotes(value));

		if (dbType.isOrderRequired()) {
			statement.append(", ");
			statement.append(addQuotes(order));
		}

		statement.append(" FROM ");
		statement.append(addQuotes(table.getName()));
	}

	protected void createWhereClause(int begin) {
		statement.append(" WHERE ");
		statement.append(addQuotes(id));
		statement.append(" IN (");
		boolean first = true;

		for (int i = begin; i < ids.length; i++) {
			if (ids[i] == 0)
				continue;

			String id = "" + ids[i];

			if (statement.length() + id.length() > dbType.getMaximumSQLLength()) {
				initial = i;
				break;
			}

			if (first)
				first = false;
			else
				statement.append(", ");

			statement.append(ids[i]);
		}

		statement.append(")");
	}

	protected void createOrderClause() {
		statement.append(" ORDER BY ");
		statement.append(addQuotes(id));
		statement.append(", ");
		statement.append(addQuotes(order));
	}
} // AttributeQuery
