/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContainsQuery.java,v 1.4 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class generates an SQL SELECT statement that returns rows of referenced
 * objects with the given referencedId for the object with the given id.
 */
public class ContainsQuery extends QueryStatement {
	protected Column source;
	protected Column target;
	protected Integer id;
	protected Integer referencedId;

	public ContainsQuery(DatabaseType type, DBMap map, Integer id, EReference reference, Integer referencedId) {
		super(type, map, reference);
		this.id = id;
		this.referencedId = referencedId;
		DBMap.ReferenceData data;
		data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
		source = data.getSourceColumn();
		target = data.getTargetColumn();
	}

	public String getStatement() {
		if (statement.length() != 0)
			return statement.toString();

		statement.append("SELECT ");
		statement.append(addQuotes(target.getName()));
		statement.append(" FROM ");
		statement.append(addQuotes(table.getName()));

		createWhereClause();
		return statement.toString();
	}

	protected void createWhereClause() {
		statement.append(" WHERE ");
		statement.append(addQuotes(source.getName()));
		statement.append(" = ");
		statement.append(id);
		statement.append(" AND ");
		statement.append(addQuotes(target.getName()));
		statement.append(" = ");
		statement.append(referencedId);
	}

	public EClass getEClass() {
		return null;
	}

	public String getKeyName() {
		return null;
	}
} // ContainsQuery
