/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBCommand.java,v 1.5 2005/02/16 22:21:29 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;

/**
 * This class represents a generic database command.
 */
public class DBCommand {
	protected JDBCHelper helper;

	protected DBMap dbMap;

	protected DatabaseType dbType;

	protected static boolean debug = false;

	protected boolean usePreparedStatement = true;

	/**
	 * Constructor for DBCommand.
	 */
	public DBCommand(JDBCHelper helper, DBMap map) {
		super();
		this.dbType = helper.getDatabaseType();
		this.helper = helper;
		dbMap = map;
	}

	protected String addQuotes(String name) {
		if (!helper.getDatabaseType().getAddQuotes())
			return name;
		else
			return "\"" + name + "\"";
	}

	/**
	 * Executes the command, and returns a result, which may be null.
	 */
	public Object execute() throws Exception {
		throw new UnsupportedOperationException();
	}

} // DBCommand
