/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBVisitorFactoryImpl.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.resources.database.internal.DBVisitor;
import org.eclipse.hyades.resources.database.internal.DBVisitorFactory;
import org.eclipse.hyades.resources.database.internal.Database;
/**
 * Creates a DBVisitorImpl.
 */
public class DBVisitorFactoryImpl implements DBVisitorFactory {
	public DBVisitorFactoryImpl() {
		super();
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBVisitorFactory#create(org.eclipse.hyades.resources.database.internal.Database,
	 *      int)
	 */
	public DBVisitor create(Database database, int pagingSize) {
		return new DBVisitorImpl(database, pagingSize);
	}
} // DBVisitorFactoryImpl
