/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeleteStatement.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * Generates a DELETE statement to delete the rows from the table; splits the
 * statement if it becomes too long.
 */
public class DeleteStatement extends SQLStatement {
	protected EClass eClass;
	protected List ids;
	protected DBMap.ClassData data;
	protected Column primaryKey;
	protected String[] statements;
	protected List statementList;
	protected StringBuffer header;
	public DeleteStatement(DBMap map, DatabaseType dbType, EClass eClass, List ids) {
		super(dbType,map);
		this.eClass = eClass;
		this.ids = ids;
		data = (DBMap.ClassData) dbMap.getDBRepresentation(eClass);
		RDBHelper helper = new RDBHelper();
		primaryKey = helper.getPrimaryKey(data.getTable());
	}

	public String getStatement() {
		StringBuffer buffer = new StringBuffer();

		if (header == null)
			createHeader();

		buffer = buffer.append(header);
		appendIds(buffer, 0);

		if (statementList == null)
			return buffer.toString();
		else {
			statements = (String[]) statementList.toArray(new String[statementList.size()]);
			return null;
		}
	}

	public String[] getStatements() {
		return statements;
	}

	protected void createHeader() {
		header = new StringBuffer();
		header.append("DELETE FROM ");
		header.append(addQuotes(data.getTable().getName()));
		header.append(" WHERE ");
		header.append(addQuotes(primaryKey.getName()));
		header.append(" IN (");
	}

	protected void appendIds(StringBuffer buffer, int position) {
		for (int i = position, l = ids.size(); i < l; i++) {
			StringBuffer currentId = new StringBuffer();

			if (i != position)
				currentId.append(", ");

			currentId.append((Integer) ids.get(i));

			if (buffer.length() + currentId.length() > dbType.getMaximumSQLLength()) {
				buffer.append(")");
				addToStatementList(buffer);
				StringBuffer nextStatement = createNextStatement();
				appendIds(nextStatement, i);
				return;
			} else {
				buffer.append(currentId);
			}
		}

		buffer.append(")");

		if (statementList != null)
			addToStatementList(buffer);
	}

	protected void addToStatementList(StringBuffer statement) {
		if (statementList == null)
			statementList = new ArrayList();

		statementList.add(statement.toString());
	}

	protected StringBuffer createNextStatement() {
		StringBuffer next = new StringBuffer();
		next.append(header);
		return next;
	}
} // DeleteStatement
