/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetByQueryCommand.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class is the superclass for the command classes that obtain objects
 * according to ObjectQuery and ReferenceQuery.
 */
public class GetByQueryCommand extends DBCommand {
	protected DatabaseType type;
	protected DBCommandFactory factory;
	protected WeakObjectCache cache;

	public GetByQueryCommand(JDBCHelper helper, DBMap map, DatabaseType type, WeakObjectCache cache) {
		super(helper, map);
		this.type = type;
		this.cache = cache;
		factory = DBCommandFactory.INSTANCE;
	}

	protected DBCommand createGet(EClass eClass, Integer id, boolean contain) {
		List classesAndIds = new ArrayList();
		classesAndIds.add(eClass);
		List ids = new ArrayList();
		ids.add(id);
		classesAndIds.add(ids);

		return factory.createGetCommand(helper, dbMap, type, classesAndIds, contain, cache, null, null);
	}

	protected DBCommand createGet(EClass eClass, List ids, boolean contain, Collection notLoadedClasses) {
		List classesAndIds = new ArrayList();
		classesAndIds.add(eClass);
		classesAndIds.add(ids);

		return factory.createGetCommand(helper, dbMap, type, classesAndIds, contain, cache, notLoadedClasses, null);
	}

	/**
	 * Converts the list of EObjects to an array of EObjects; if the list is
	 * empty, null is returned.
	 */
	protected EObject[] toArray(List objects) {
		if (objects == null || objects.isEmpty())
			return null;
		else
			return (EObject[]) objects.toArray(new EObject[objects.size()]);
	}

	/**
	 * Get the object with the given EClass, id, and containment option.
	 */
	protected EObject getObject(EClass eClass, Integer id, boolean contained) throws Exception {
		DBCommand get = createGet(eClass, id, contained);
		List objects = (List) get.execute();

		if (objects.isEmpty())
			return null;
		else
			return (EObject) objects.get(0);
	}

	/**
	 * Create get commands to retrieve the objects from the given class and
	 * given containment option with the given database ids. Populate dbObjects
	 * with the objects, if it is not null.
	 */
	protected List getObjects(EClass eClass, List ids, boolean contained, Collection notLoadedClasses) throws Exception {
		if (ids.isEmpty())
			return null;

		PerfUtil p = new PerfUtil("GetByQueryCommand.getObjects()",true);
		DBCommand get = createGet(eClass, ids, contained, notLoadedClasses);
		List objects = (List) get.execute();
		p.stopAndPrintStatus("size="+objects.size());

		if (objects.isEmpty())
			return null;
		else
			return objects;
	}
} // GetByQueryCommand
