/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetTargetIdStatement.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This statement gets the id of the target object for a specific source ID and order index
 */
public class GetTargetIdStatement extends QueryStatement {
	protected int sourceId,index;
	protected String source, target, order;
	protected boolean orderFlag;

	public GetTargetIdStatement(DBMap map, DatabaseType dbType,int sourceId, EReference reference,int index) {
		super(dbType, map, reference);
		this.sourceId = sourceId;

		this.index = index;
		
		DBMap.ReferenceData data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
		source = data.getSourceColumn().getName();
		target = data.getTargetColumn().getName();

		if (data.getOrderColumn() != null)
			order = data.getOrderColumn().getName();

		initial = 0;
	}

	protected void createSelectFrom() {
		statement.append("SELECT ");

		statement.append(addQuotes(target));

		statement.append(" FROM ");
		statement.append(addQuotes(table.getName()));
	}

	protected void createWhereClause(int begin) {
		statement.append(" WHERE ");
		statement.append(addQuotes(source));
		statement.append(" = ");
		String id = "" + sourceId;
		statement.append(id);
		statement.append(" AND ");
		statement.append(addQuotes(order));
		statement.append(" = ");
		id = "" + index;
		statement.append(id);
	}
} // GetTargetIdStatement
