/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoadCommand.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class creates a resource, then gets the top-level objects using a get
 * command and adds them to the contents of the resource.
 */
public class LoadCommand extends DBCommand {
	protected DatabaseType type;
	protected Resource resource;
	protected boolean allObjects;
	protected Collection notLoadedClasses;
	protected WeakObjectCache cache;

	public LoadCommand(JDBCHelper helper, DBMap map, DatabaseType type, Resource resource, boolean allObjects, Collection notLoadedClasses, WeakObjectCache cache) {
		super(helper, map);
		this.type = type;
		this.resource = resource;
		this.allObjects = allObjects;
		this.notLoadedClasses = notLoadedClasses;
		this.cache = cache;
	}

	public Object execute() throws Exception {
		DBCommand getTopLevelObjects = DBCommandFactory.INSTANCE.createGetTopLevelObjects(helper, dbMap, resource.getURI());
		List topLevel = (List) getTopLevelObjects.execute();
		createObjects(topLevel);
		return null;
	}

	protected void createObjects(List topLevel) throws Exception {
		DBCommandFactory factory = DBCommandFactory.INSTANCE;
		DBCommand get = factory.createGetCommand(helper, dbMap, type, topLevel, allObjects, cache, notLoadedClasses, resource.getURI().toString(), resource);
		List objects = (List) get.execute();

		if (!objects.isEmpty())
			for (int i = 0, l = objects.size(); i < l; i++)
				resource.getContents().add(objects.get(i));
	}
} // LoadCommand
