/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PagingListFactory.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.IPagingListFactory;
import org.eclipse.hyades.resources.database.internal.DBResource;
/**
 * This factory creates a DynamicPagingListImpl object and returns it, if the
 * owner is in a DBResource. Otherwise, it returns null.
 */
public class PagingListFactory implements IPagingListFactory {
	protected static final int DEFAULT_PAGING_SIZE = 100;
	protected int pagingSize = DEFAULT_PAGING_SIZE;

	private PagingListFactory() {
		super();
	}

	public static final PagingListFactory INSTANCE = new PagingListFactory();

	public EList createPagingList(EObject owner, EStructuralFeature eStructuralFeature) {
		Resource resource = owner.eResource();

		if (resource != null && resource instanceof DBResource) {
			DynamicPagingListImpl list = new DynamicPagingListImpl((InternalEObject) owner, eStructuralFeature, (DBResource) resource, getPagingSize());
			return list;
		} else
			return null;
	}

	public EList createPagingList(Class dataClass, EObject owner, int featureID) {
		return createPagingList(owner, owner.eClass().getEStructuralFeature(featureID));
	}

	public EList createPagingList(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
		return createPagingList(owner, owner.eClass().getEStructuralFeature(featureID));
	}

	public void setPagingSize(int size) {
		pagingSize = size;
	}

	public int getPagingSize() {
		return pagingSize;
	}
} // PagingListFactory
