/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SQLStatement.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class represents the implementation of an SQLStatement.
 */
public abstract class SQLStatement {
	protected DBMap dbMap;
	protected StringBuffer statement;
	protected boolean debugPreparedStatement=false;

	/**
	 * Constructor for SQLStatement.
	 */
	public SQLStatement(DatabaseType type,DBMap map) {
		super();
		this.dbType = type;
		dbMap = map;
		statement = new StringBuffer();
	}

	/**
	 * This method returns the String representation of the statement, creating
	 * it if necessary.
	 */
	abstract public String getStatement();

	public String toString() {
		return getStatement();
	}

	protected DatabaseType dbType;

	protected String addQuotes(String name) {
		if (!dbType.getAddQuotes())
			return name;
		else
			return "\"" + name + "\"";
	}

} // SQLStatement
