/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SetAttributeStatement.java,v 1.4 2005/02/16 22:21:31 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.Types;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * Generates an UPDATE statement to set an attribute value. Currently, only
 * single-valued attributes are supported.
 */
public class SetAttributeStatement extends SQLStatement {
	protected Integer id;
	protected EAttribute attribute;
	protected Object value;

	public SetAttributeStatement(DatabaseType dbType,DBMap map, Integer id, EAttribute attribute, Object value) {
		super(dbType,map);
		this.id = id;
		this.attribute = attribute;
		this.value = value;
	}

	public String getStatement() {
		StringBuffer buffer = new StringBuffer();
		DBMap.AttributeData data = (DBMap.AttributeData) dbMap.getDBRepresentation(attribute);
		buffer.append("UPDATE ");
		buffer.append(addQuotes(data.getValueColumn().getTable().getName()));
		buffer.append(" SET ");
		buffer.append(addQuotes(data.getValueColumn().getName()));
		buffer.append(" = ");
		writeValue(buffer, data.getValueColumn().getType().getSqlType());

		Column primaryKey = new RDBHelper().getPrimaryKey(data.getValueColumn().getTable());

		if (primaryKey == null)
			return "";

		buffer.append(" WHERE ");
		buffer.append(addQuotes(primaryKey.getName()));
		buffer.append(" = ");
		buffer.append(id);

		return buffer.toString();
	}

	protected void writeValue(StringBuffer buffer, int sqlType) {
		if (value == null)
			buffer.append("NULL");
		else if (sqlType == Types.CHAR || sqlType == Types.VARCHAR || sqlType == Types.LONGVARCHAR) {
			buffer.append("'");
			String valueString = value.toString();

			for (int i = 0, l = valueString.length(); i < l; i++) {
				char c = valueString.charAt(i);

				if (c == '\'')
					buffer.append("''");
				else
					buffer.append(c);
			}

			buffer.append("'");
		} else {
			buffer.append(value.toString());
		}
	}
} // SetAttributeStatement
