/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SimpleSearchCommand.java,v 1.7 2005/03/04 22:17:17 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;

/**
 * @author slavescu
 */
public class SimpleSearchCommand extends DBCommand {

	private SimpleSearchQuery query;
	private ResourceSet resourceSet;
	private WeakObjectCache cache;
	private Collection notLoadedClasses;
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.resources.database.internal.impl.DBCommand#execute()
	 */
	public Object execute() throws Exception {
		SQLStatement ssqs = StatementFactory.INSTANCE.createSimpleSearchQueryStatement(helper, dbMap, query);
		String s = ssqs.getStatement();
		QueryResult queryResult = ExtensionsFactory.eINSTANCE.createQueryResult();
		queryResult.setQuery(query);
		Statement st = helper.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
		PerfUtil p = new PerfUtil("SimpleSearchCommand.execute() 1 statement="+s,true);
		try {
			helper.executeQuery(st, s);
		} catch (Exception e) {
			p.stopAndPrintStatus(e.getLocalizedMessage());
			throw e;
		}
		p.stopAndPrintStatus();
		
		ResultSet rs = st.getResultSet();
		for (int i=0;i<query.getOutputElements().size();i++) {
			EList objects;
			if(query.isCount())// || ((Operand)query.getOutputElements().get(i)).isCount())
			{
				objects = new BasicEList();
				rs.absolute(1);
				Integer count = new Integer(rs.getInt(i+1));
				objects.add(count);
			}
			else
			{
				objects = new IndirectedList(helper,dbMap,cache,query,s,resourceSet,notLoadedClasses,rs,i);
			}
			ResultEntry resultEntry = ExtensionsFactory.eINSTANCE.createResultEntry();
			resultEntry.setValue(objects);
			queryResult.getResultEntries().add(resultEntry);
			
		}
		
		return queryResult;
	}
	

	/**
	 * 
	 */
//	private void addNotLoadedClasses() {
//		EClass eClass=null;
//		for (Iterator iter = query.getOutputElements().iterator(); iter.hasNext();) {
//			Operand oe = (Operand) iter.next();
//			if (oe.getFeature() != null) {
//				eClass = oe.getFeature().getEContainingClass();
//			} else if (oe.getType() != null) {
//				eClass = oe.getType();
//			}
//			if(eClass!=null && !notLoadedClasses.contains(eClass))
//			{
//				notLoadedClasses.add(eClass);
//				eClass=null;
//			}
//		}
//	}

	/**
	 *  
	 */
	public SimpleSearchCommand(JDBCHelper helper, DBMap map, SimpleSearchQuery query, ResourceSet resourceSet,WeakObjectCache cache,Collection notLoadedClasses) {
		super(helper, map);
		this.query = query;
		this.resourceSet = resourceSet;
		this.cache = cache;
		this.notLoadedClasses = notLoadedClasses;
	}
	
	
}