/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CBEUtils.java,v 1.12 2005/05/13 14:57:23 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
/**
 * @author slavescu
 */
public class CBEUtils {
	//~ Methods ------------------------------------------------------------------------------------
	public static double computeAdjustedCreationTime(CBECommonBaseEvent event) {
		double creationTime = event.getCreationTime();
		try {
			if (event.getAgent().getAgentProxy().getDeltaTime() != 0) {
				return creationTime + event.getAgent().getAgentProxy().getDeltaTime();
			} else {
				return creationTime + event.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
			}
		} catch (Exception e) {
		}
		return creationTime;
	}
	/**
	 * Method formatCreationTime.
	 * 
	 * @param element
	 * @return String
	 */
	public static String formatCreationTime(CBECommonBaseEvent event, DateFormat dateFormat) {
		short zone = event.getTimeZone();
		return formatCreationTime(event, dateFormat, zone);
	}
	/**
	 * @param event
	 * @param dateFormat
	 * @param zone in minutes
	 * @return
	 */
	public static String formatCreationTime(CBECommonBaseEvent event, DateFormat dateFormat, short zone) {
		// If time is not specified, use "0".
		if (event.getCreationTime() != 0) {
			try {
				double ct = computeAdjustedCreationTime(event);
				Double l2 = new Double(ct);
				long r = (long)(((Double) l2).doubleValue() % 1000000); 
				if(r<0){
					r = 1000000+r;
				}
				String microseconds = "" + r;
				
				String ms = "." + "000000".substring(0, 6 - microseconds.length()) + microseconds;
//				ms = ms + (zone > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(zone / 60)).length()) + Math.abs(zone / 60);
//				ms = ms + ":00".substring(0, 3 - ("" + Math.abs(zone % 60)).length()) + Math.abs(zone % 60);
				StringBuffer toAppendTo = new StringBuffer();
				FieldPosition fieldPosition = new FieldPosition(DateFormat.SECOND_FIELD);
				TimeZone timeZone = new SimpleTimeZone(zone * 60 * 1000,"");//(zone > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(zone / 60)).length()) + Math.abs(zone / 60));
				dateFormat.setTimeZone(timeZone);
				dateFormat.format(new Date(((Double) l2).longValue() / 1000), toAppendTo, fieldPosition);
				if (fieldPosition.getEndIndex() > 0) {
					toAppendTo.insert(fieldPosition.getEndIndex(), ms);
				}
				return toAppendTo.toString();
			} catch (Exception e) {
				LoadersUtils.log(e);
			}
		}
		return "0";
	}
}