/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CBEDefaultEvent.java,v 1.10 2005/05/09 05:05:15 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe;

import org.eclipse.emf.common.util.EList;

import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Default Event</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A default event is the parent of any class that you wish to pass to an analysis 
 * engine. It will be marked isAnalyzed by the engine as appropriate.
 * The default event is also the most minimal event that can be logged. As an 
 * isntance, all values logged are held in a structure of default elements.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent#isAnalyzed <em>Analyzed</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent#getExtensionName <em>Extension Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent#getSymptoms <em>Symptoms</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent#getExtendedProperties <em>Extended Properties</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBEDefaultEvent()
 * @model 
 * @generated
 */
public interface CBEDefaultEvent extends AbstractDefaultEvent{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Analyzed</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Analyzed</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * this member is used to indicate if the event has been analyzed by an engine.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Analyzed</em>' attribute.
	 * @see #setAnalyzed(boolean)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBEDefaultEvent_Analyzed()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isAnalyzed();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent#isAnalyzed <em>Analyzed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Analyzed</em>' attribute.
	 * @see #isAnalyzed()
	 * @generated
	 */
	void setAnalyzed(boolean value);

	/**
	 * Returns the value of the '<em><b>Extension Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Extension Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extension Name</em>' attribute.
	 * @see #setExtensionName(String)
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBEDefaultEvent_ExtensionName()
	 * @model 
	 * @generated
	 */
	String getExtensionName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent#getExtensionName <em>Extension Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Extension Name</em>' attribute.
	 * @see #getExtensionName()
	 * @generated
	 */
	void setExtensionName(String value);

	/**
	 * Returns the value of the '<em><b>Symptoms</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.internal.sdb.SDBSymptom}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Symptoms</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Symptoms</em>' reference list.
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBEDefaultEvent_Symptoms()
	 * @model type="org.eclipse.hyades.models.internal.sdb.SDBSymptom" transient="true"
	 * @generated
	 */
	EList getSymptoms();

	/**
	 * Returns the value of the '<em><b>Extended Properties</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.cbe.CBEDefaultElement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Extended Properties</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extended Properties</em>' containment reference list.
	 * @see org.eclipse.hyades.models.cbe.CBEPackage#getCBEDefaultEvent_ExtendedProperties()
	 * @model type="org.eclipse.hyades.models.cbe.CBEDefaultElement" containment="true"
	 * @generated
	 */
	EList getExtendedProperties();

} // CBEDefaultEvent
