/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CBEAvailableSituationImpl.java,v 1.5 2005/05/09 05:05:15 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.hyades.models.cbe.CBEAvailableSituation;
import org.eclipse.hyades.models.cbe.CBEPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Available Situation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEAvailableSituationImpl#getOperationDisposition <em>Operation Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEAvailableSituationImpl#getProcessingDisposition <em>Processing Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEAvailableSituationImpl#getAvailabilityDisposition <em>Availability Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CBEAvailableSituationImpl extends CBESituationImpl implements CBEAvailableSituation {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getOperationDisposition() <em>Operation Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperationDisposition()
	 * @generated
	 * @ordered
	 */
	protected static final String OPERATION_DISPOSITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOperationDisposition() <em>Operation Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperationDisposition()
	 * @generated
	 * @ordered
	 */
	protected String operationDisposition = OPERATION_DISPOSITION_EDEFAULT;

	/**
	 * The default value of the '{@link #getProcessingDisposition() <em>Processing Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessingDisposition()
	 * @generated
	 * @ordered
	 */
	protected static final String PROCESSING_DISPOSITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProcessingDisposition() <em>Processing Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessingDisposition()
	 * @generated
	 * @ordered
	 */
	protected String processingDisposition = PROCESSING_DISPOSITION_EDEFAULT;

	/**
	 * The default value of the '{@link #getAvailabilityDisposition() <em>Availability Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAvailabilityDisposition()
	 * @generated
	 * @ordered
	 */
	protected static final String AVAILABILITY_DISPOSITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAvailabilityDisposition() <em>Availability Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAvailabilityDisposition()
	 * @generated
	 * @ordered
	 */
	protected String availabilityDisposition = AVAILABILITY_DISPOSITION_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CBEAvailableSituationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return CBEPackage.eINSTANCE.getCBEAvailableSituation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOperationDisposition() {
		return operationDisposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperationDisposition(String newOperationDisposition) {
		String oldOperationDisposition = operationDisposition;
		operationDisposition = newOperationDisposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_AVAILABLE_SITUATION__OPERATION_DISPOSITION, oldOperationDisposition, operationDisposition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getProcessingDisposition() {
		return processingDisposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessingDisposition(String newProcessingDisposition) {
		String oldProcessingDisposition = processingDisposition;
		processingDisposition = newProcessingDisposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_AVAILABLE_SITUATION__PROCESSING_DISPOSITION, oldProcessingDisposition, processingDisposition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAvailabilityDisposition() {
		return availabilityDisposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAvailabilityDisposition(String newAvailabilityDisposition) {
		String oldAvailabilityDisposition = availabilityDisposition;
		availabilityDisposition = newAvailabilityDisposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION, oldAvailabilityDisposition, availabilityDisposition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_AVAILABLE_SITUATION__CATEGORY_NAME:
				return getCategoryName();
			case CBEPackage.CBE_AVAILABLE_SITUATION__REASONING_SCOPE:
				return getReasoningScope();
			case CBEPackage.CBE_AVAILABLE_SITUATION__OPERATION_DISPOSITION:
				return getOperationDisposition();
			case CBEPackage.CBE_AVAILABLE_SITUATION__PROCESSING_DISPOSITION:
				return getProcessingDisposition();
			case CBEPackage.CBE_AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION:
				return getAvailabilityDisposition();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_AVAILABLE_SITUATION__CATEGORY_NAME:
				setCategoryName((String)newValue);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__REASONING_SCOPE:
				setReasoningScope((String)newValue);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__OPERATION_DISPOSITION:
				setOperationDisposition((String)newValue);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__PROCESSING_DISPOSITION:
				setProcessingDisposition((String)newValue);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION:
				setAvailabilityDisposition((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_AVAILABLE_SITUATION__CATEGORY_NAME:
				setCategoryName(CATEGORY_NAME_EDEFAULT);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__REASONING_SCOPE:
				setReasoningScope(REASONING_SCOPE_EDEFAULT);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__OPERATION_DISPOSITION:
				setOperationDisposition(OPERATION_DISPOSITION_EDEFAULT);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__PROCESSING_DISPOSITION:
				setProcessingDisposition(PROCESSING_DISPOSITION_EDEFAULT);
				return;
			case CBEPackage.CBE_AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION:
				setAvailabilityDisposition(AVAILABILITY_DISPOSITION_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_AVAILABLE_SITUATION__CATEGORY_NAME:
				return CATEGORY_NAME_EDEFAULT == null ? categoryName != null : !CATEGORY_NAME_EDEFAULT.equals(categoryName);
			case CBEPackage.CBE_AVAILABLE_SITUATION__REASONING_SCOPE:
				return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
			case CBEPackage.CBE_AVAILABLE_SITUATION__OPERATION_DISPOSITION:
				return OPERATION_DISPOSITION_EDEFAULT == null ? operationDisposition != null : !OPERATION_DISPOSITION_EDEFAULT.equals(operationDisposition);
			case CBEPackage.CBE_AVAILABLE_SITUATION__PROCESSING_DISPOSITION:
				return PROCESSING_DISPOSITION_EDEFAULT == null ? processingDisposition != null : !PROCESSING_DISPOSITION_EDEFAULT.equals(processingDisposition);
			case CBEPackage.CBE_AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION:
				return AVAILABILITY_DISPOSITION_EDEFAULT == null ? availabilityDisposition != null : !AVAILABILITY_DISPOSITION_EDEFAULT.equals(availabilityDisposition);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operationDisposition: ");
		result.append(operationDisposition);
		result.append(", processingDisposition: ");
		result.append(processingDisposition);
		result.append(", availabilityDisposition: ");
		result.append(availabilityDisposition);
		result.append(')');
		return result.toString();
	}

} //CBEAvailableSituationImpl
