/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;

public class DatapoolUtil {
    private static final DatapoolUtil instance = new DatapoolUtil();

    public static DatapoolUtil getInstance() {
        return instance;
    }

    protected DatapoolUtil() {
    }

    public boolean isVariableNameValid(String name) {
        if (name.length() == 0) {
            return false;
        }
        String invalidCharacters = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS");
        return !this.hasInvalidCharacters(name, invalidCharacters = invalidCharacters.replaceAll(" ", ""));
    }

    public boolean isVariableTypeValid(String type) {
        if (type.length() == 0) {
            return true;
        }
        String invalidCharacters = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_TYPE_CHARACTERS");
        String invalidFirstCharacter = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_TYPE_FIRST_CHARACTER");
        if (this.hasInvalidCharacters(type.substring(0, 1), invalidFirstCharacter)) {
            return false;
        }
        return !this.hasInvalidCharacters(type, invalidCharacters);
    }

    public boolean isEquivalenceClassNameValid(String name) {
        if (name.length() == 0) {
            return false;
        }
        String invalidCharacters = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS");
        return !this.hasInvalidCharacters(name, invalidCharacters = invalidCharacters.replaceAll(" ", ""));
    }

    public boolean hasInvalidCharacters(String value, String invalidCharacters) {
        if (invalidCharacters == null) {
            return false;
        }
        int i = 0;
        while (i < invalidCharacters.length()) {
            String character = invalidCharacters.substring(i, i + 1);
            if (value.lastIndexOf(character) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEquivalenceClassNameUnique(IDatapool datapool, String name, IDatapoolEquivalenceClass excludeEquivalenceClass) {
        if (datapool == null) {
            return true;
        }
        int i = 0;
        while (i < datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
            if (!equivalenceClass.equals(excludeEquivalenceClass) && name.equals(equivalenceClass.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isVariableNameUnique(IDatapool datapool, String name, IDatapoolVariable excludeVariable) {
        if (datapool == null) {
            return true;
        }
        int i = 0;
        while (i < datapool.getVariableCount()) {
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
            if (!variable.equals(excludeVariable) && name.equals(variable.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IDatapoolVariable[] getVariables(IDatapool datapool, String exclusionName) {
        if (datapool == null) {
            return null;
        }
        int variableCount = datapool.getVariableCount();
        ArrayList<IDatapoolVariable> tempList = new ArrayList<IDatapoolVariable>();
        int i = 0;
        while (i < variableCount) {
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
            String variableName = variable.getName();
            if (!variableName.equals(exclusionName)) {
                tempList.add(variable);
            }
            ++i;
        }
        int listSize = tempList.size();
        IDatapoolVariable[] returnList = new IDatapoolVariable[listSize];
        tempList.toArray(returnList);
        return returnList;
    }

    public IDatapoolEquivalenceClass[] getEquivalenceClasses(IDatapool datapool, String exclusionID) {
        if (datapool == null) {
            return null;
        }
        int equivalenceClassCount = datapool.getEquivalenceClassCount();
        ArrayList<IDatapoolEquivalenceClass> tempList = new ArrayList<IDatapoolEquivalenceClass>();
        int i = 0;
        while (i < equivalenceClassCount) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
            String equivalenceClassID = equivalenceClass.getId();
            if (!equivalenceClassID.equals(exclusionID)) {
                tempList.add(equivalenceClass);
            }
            ++i;
        }
        int listSize = tempList.size();
        IDatapoolEquivalenceClass[] returnList = new IDatapoolEquivalenceClass[listSize];
        tempList.toArray(returnList);
        return returnList;
    }

    public String getVariableTypeInfo(IDatapoolVariable variable) {
        if (variable == null) {
            return IDatapoolSuggestedType.TYPE_DISPLAY_STRING;
        }
        String type = new String();
        org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType suggestedType = (org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType)variable.getSuggestedType();
        if (suggestedType != null) {
            String className = suggestedType.getSuggestedClassName();
            if (className != null && className.length() > 0) {
                type = className;
            } else {
                switch (suggestedType.getSuggestedType()) {
                    case 2: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_BOOLEAN;
                        break;
                    }
                    case 1: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_NUMBER;
                        break;
                    }
                    case 3: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_ENUMERATION;
                        break;
                    }
                    case 4: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_COMPLEX;
                        break;
                    }
                    default: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_STRING;
                    }
                }
            }
        }
        return type;
    }

    public String createUniqueECName(IDatapool datapool) {
        int suffix = 1;
        Object[] nameElements = new String[]{DatapoolPlugin.getResourceString("DATA_EC_NAME"), String.valueOf(suffix)};
        String nameFormat = DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME_FORMAT");
        String name = MessageFormat.format(nameFormat, nameElements);
        while (!this.isEquivalenceClassNameUnique(datapool, name, null)) {
            nameElements[1] = String.valueOf(++suffix);
            name = MessageFormat.format(nameFormat, nameElements);
        }
        return name;
    }
}

