/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.internal.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.internal.codegen.ImportManager;
import org.eclipse.hyades.test.common.internal.codegen.JavaGenerator;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.codegen.GenSuiteMethod;
import org.eclipse.hyades.test.java.internal.codegen.GenTestMethod;
import org.eclipse.hyades.test.java.internal.codegen.GenTestSuite;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JUnitGenerator
extends JavaGenerator {
    protected void generateFile(ITestSuite iTestSuite, IFile iFile, IProgressMonitor iProgressMonitor) throws Exception {
        GenTestSuite genTestSuite = new GenTestSuite();
        String string = Helper.formatContent((String)genTestSuite.generate(iTestSuite, new Helper()));
        iFile.create((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), true, iProgressMonitor);
        iFile.setCharset("UTF-8", iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFile(ITestSuite iTestSuite, IFile iFile, IProgressMonitor iProgressMonitor) {
        boolean bl;
        Helper helper;
        ICompilationUnit iCompilationUnit;
        iProgressMonitor.beginTask("", 4);
        try {
            iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFile);
            helper = new Helper();
            String string = helper.getPackageName((Object)iTestSuite);
            helper.setImportManager(new ImportManager(string));
            bl = false;
            if (iCompilationUnit != null && iCompilationUnit.isStructureKnown()) break block6;
            bl = true;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        {
            block6: {
                return;
            }
            try {
                IType iType = iCompilationUnit.findPrimaryType();
                iCompilationUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (!iTestSuite.getImplementor().isExternalImplementor()) {
                    this.updateSuiteMethod(iTestSuite, iType, helper);
                }
                iProgressMonitor.worked(1);
                this.updateTestMethods(iTestSuite, iType, helper, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                helper.emitSortedImports(iCompilationUnit);
                iCompilationUnit.commitWorkingCopy(false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            catch (JavaModelException javaModelException) {
                TestJavaPlugin.logError(javaModelException);
                bl = true;
            }
        }
        Object var10_9 = null;
        iProgressMonitor.done();
    }

    protected void updateSuiteMethod(ITestSuite iTestSuite, IType iType, Helper helper) throws JavaModelException {
        GenSuiteMethod genSuiteMethod = new GenSuiteMethod();
        String string = genSuiteMethod.generate(iTestSuite, helper);
        IMethod iMethod = iType.getMethod("suite", new String[0]);
        IMethod iMethod2 = null;
        if (iMethod.exists()) {
            IMethod[] iMethodArray = iType.getMethods();
            int n = Arrays.asList(iMethodArray).indexOf(iMethod);
            iMethod.delete(false, (IProgressMonitor)new NullProgressMonitor());
            iMethodArray = iType.getMethods();
            if (n < iMethodArray.length) {
                iMethod2 = iMethodArray[n];
            }
        } else {
            IMethod[] iMethodArray = iType.getMethods();
            if (iMethodArray.length > 0) {
                iMethod2 = iMethodArray[0];
            }
        }
        iType.createMethod(Helper.formatContent((String)string, (int)1), (IJavaElement)iMethod2, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean isTestMethod(IMethod iMethod) {
        String string = iMethod.getElementName();
        String[] stringArray = iMethod.getParameterTypes();
        return string.startsWith("test") && stringArray.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTestMethods(ITestSuite iTestSuite, IType iType, Helper helper, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        iProgressMonitor.beginTask("", iMethodArray.length + iTestSuite.getITestCases().size());
        try {
            ArrayList<IMethod> arrayList = new ArrayList<IMethod>(iMethodArray.length);
            Iterator iterator = iTestSuite.getITestCases().iterator();
            while (iterator.hasNext()) {
                ITestCase iTestCase = (ITestCase)iterator.next();
                String string = helper.getTestMethodName(iTestCase);
                IMethod iMethod = iType.getMethod(string, new String[0]);
                if (!iMethod.exists()) {
                    iMethod = this.createTestMethod(iType, iTestCase, helper);
                }
                arrayList.add(iMethod);
                iProgressMonitor.worked(1);
            }
            int n = 0;
            while (n < iMethodArray.length) {
                if (this.isTestMethod(iMethodArray[n]) && !arrayList.contains(iMethodArray[n])) {
                    iMethodArray[n].delete(false, (IProgressMonitor)new NullProgressMonitor());
                }
                iProgressMonitor.worked(1);
                ++n;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    protected IMethod createTestMethod(IType iType, ITestCase iTestCase, Helper helper) throws JavaModelException {
        GenTestMethod genTestMethod = new GenTestMethod();
        String string = genTestMethod.generate(iTestCase, helper);
        return iType.createMethod(string, null, false, (IProgressMonitor)new NullProgressMonitor());
    }
}

