/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RunInstancesPage
extends WizardPage
implements Listener {
    private Text nusersText;
    private String description;
    private int nusers = 1;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public RunInstancesPage() {
        super("instances");
        this.setTitle(TestUIPlugin.getString((String)"RUN_WTITLE"));
        this.setDescription(TestHttpPlugin.getString("RUN_IDESC"));
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(TestHttpPlugin.getString("NUMBER_OF_USERS"));
        label.setFont(font);
        this.nusersText = new Text(composite2, 2048);
        this.nusersText.addListener(24, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.nusersText.setLayoutData((Object)gridData);
        this.nusersText.setFont(font);
        this.nusersText.setText(String.valueOf(this.nusers));
        this.setControl((Control)composite2);
        this.setPageComplete(this.validatePage());
    }

    protected void addControl(Composite composite) {
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.nusersText.setFocus();
            this.nusersText.selectAll();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        String string = this.nusersText.getText();
        try {
            Integer n = Integer.valueOf(string);
            if (n < 0) {
                this.setErrorMessage(TestHttpPlugin.getString("ENTER_POSITIVE_NUMBER"));
                return false;
            }
            this.nusers = n;
            this.setErrorMessage(null);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(TestHttpPlugin.getString("ENTER_POSITIVE_NUMBER"));
            return false;
        }
    }

    public int getNusers() {
        return this.nusers;
    }

    public void setNusers(int n) {
        this.nusers = n < 1 ? 1 : n;
    }
}

