/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.local.appadapters;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.IRecorderApplicationAdapterClient;

public class RecorderAppAdapterFactory {
    private String extensionPointID = "org.eclipse.hyades.execution.recorder.RecorderApplication";
    private static RecorderAppAdapterFactory instance = null;
    private HashMap elementsByID = new HashMap();
    private HashMap clients = new HashMap();

    private RecorderAppAdapterFactory() {
    }

    public static RecorderAppAdapterFactory getInstance() {
        if (instance == null) {
            instance = new RecorderAppAdapterFactory();
            instance.loadMetdata();
        }
        return instance;
    }

    private void loadMetdata() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointID);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            this.elementsByID.put(iConfigurationElement.getAttribute("id"), iConfigurationElement);
            ++n;
        }
    }

    public String getAdapterName(String string) {
        return ((IConfigurationElement)this.elementsByID.get(string)).getAttribute("name");
    }

    public String getAgentClasspath(String string) {
        if (string.equalsIgnoreCase("-1")) {
            return string;
        }
        return ((IConfigurationElement)this.elementsByID.get(string)).getAttribute("agentclass");
    }

    public String[] getSupportedOS(String string) {
        if (string.equalsIgnoreCase("-1")) {
            return null;
        }
        String string2 = ((IConfigurationElement)this.elementsByID.get(string)).getAttribute("supportedOS");
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public IRecorderApplicationAdapterClient getClient(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, CoreException {
        Object v = this.clients.get(string);
        if (v != null) {
            return (IRecorderApplicationAdapterClient)v;
        }
        if (string.equalsIgnoreCase("-1")) {
            return null;
        }
        IConfigurationElement iConfigurationElement = (IConfigurationElement)this.elementsByID.get(string);
        IRecorderApplicationAdapterClient iRecorderApplicationAdapterClient = (IRecorderApplicationAdapterClient)iConfigurationElement.createExecutableExtension("clientclass");
        this.clients.put(string, iRecorderApplicationAdapterClient);
        return iRecorderApplicationAdapterClient;
    }

    public String[] getAdapterIDs() {
        Object[] objectArray = this.elementsByID.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    public String getAdapterIDByIndex(int n) {
        Object[] objectArray = this.elementsByID.values().toArray();
        if (n > objectArray.length - 1) {
            return null;
        }
        IConfigurationElement iConfigurationElement = (IConfigurationElement)objectArray[n];
        return iConfigurationElement.getAttribute("id");
    }

    public IConfigurationElement getAdapterConfigElement(String string) {
        return (IConfigurationElement)this.elementsByID.get(string);
    }
}

