/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public class TestExecutionHarnessExecutorStub
extends ExecutorStub {
    private static final String AGENT_TYPE = "tester";
    private static final int DEFAULT_LAUNCH_TIMEOUT = 60000;

    private CustomCommand createResumeCommand() {
        BinaryCustomCommand resumeCommand = new BinaryCustomCommand();
        resumeCommand.setData("START");
        return resumeCommand;
    }

    protected AgentListener getAgentListener() {
        return new AgentListener(){

            public void agentActive(Agent agent) {
                TestExecutionHarnessExecutorStub.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)TestExecutionHarnessExecutorStub.this, 2));
            }

            public void agentInactive(Agent agent) {
                TestExecutionHarnessExecutorStub.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)TestExecutionHarnessExecutorStub.this, 4));
            }

            public void error(Agent agent, String errorId, String errorMessage) {
                System.err.println(this + " " + errorMessage);
            }

            public void handleCommand(Agent agent, CommandElement command) {
            }
        };
    }

    private Process getAgentProcess() {
        return ((SessionStub)this.getSessionContext()).getAgent().getProcess();
    }

    private void handleException(Exception exception) {
        ExecutionHarnessPlugin.getDefault().logError(exception);
        this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)this, 4));
    }

    public void launch() throws ExecutionComponentStateException {
        this.launch((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(IProgressMonitor progressMonitor) throws ExecutionComponentStateException {
        this.doLaunch(progressMonitor);
        int timeout = this.getLaunchTimeout();
        progressMonitor.beginTask("", timeout * 10 + this.getDataProcessors().length * 12);
        try {
            try {
                this.resetAgentInitCount();
                Node node = this.getAgentProcess().getNode();
                IDataProcessor[] dataProcessors = this.getDataProcessors();
                Process process = this.waitForProcess(this.getPid(), node, timeout, progressMonitor);
                if (process == null) {
                    System.out.println("Process could not be retrieved!");
                    throw new InactiveProcessException();
                }
                if (dataProcessors != null) {
                    this.launch(process, progressMonitor, dataProcessors);
                } else {
                    this.launch(process);
                }
                Object var8_9 = null;
            }
            catch (InactiveAgentException e) {
                this.handleException((Exception)((Object)e));
                Object var8_10 = null;
                progressMonitor.done();
                return;
            }
            catch (InactiveProcessException e) {
                this.handleException((Exception)((Object)e));
                Object var8_11 = null;
                progressMonitor.done();
                return;
            }
            catch (NotConnectedException e) {
                this.handleException((Exception)((Object)e));
                Object var8_12 = null;
                progressMonitor.done();
                return;
            }
            catch (UnsupportedEncodingException e) {
                this.handleException(e);
                Object var8_13 = null;
                progressMonitor.done();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
    }

    private void launch(Process process) throws InactiveAgentException, InactiveProcessException, UnsupportedEncodingException {
        Agent agent = this.findAgent(process, AGENT_TYPE, "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        this.setupControlListener(this.getAgentListener(), agent);
        this.resume(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(Process process, IProgressMonitor progressMonitor, IDataProcessor[] dataProcessors) throws InactiveAgentException, InactiveProcessException, UnsupportedEncodingException {
        Process process2 = process;
        synchronized (process2) {
            int i = 0;
            int n = dataProcessors.length;
            while (i < n) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                progressMonitor.worked(4);
                IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dataProcessors[i];
                if (dataProcessor.getControlAgent() == null) {
                    try {
                        Agent agent = this.waitForAgent(AGENT_TYPE, dataProcessor.getName(), process, this.getLaunchTimeout(), progressMonitor);
                        if (progressMonitor.isCanceled()) {
                            return;
                        }
                        progressMonitor.worked(4);
                        if (agent != null) {
                            this.setupDataProcessor(agent, process, dataProcessor);
                            if (progressMonitor.isCanceled()) {
                                return;
                            }
                            progressMonitor.worked(4);
                            this.setupControlListener(this.getAgentListener(), agent);
                        }
                    }
                    catch (NotConnectedException e) {
                        this.handleException((Exception)((Object)e));
                    }
                }
                ++i;
            }
            IExecutionHarnessDataProcessor controller = (IExecutionHarnessDataProcessor)dataProcessors[0];
            if (controller != null) {
                this.resume(controller.getControlAgent());
            }
        }
    }

    public String performControlEvent(String controlEvent, String[] params) {
        return "";
    }

    private void resume(Agent agent) throws InactiveAgentException {
        if (agent != null) {
            agent.invokeCustomCommand(this.createResumeCommand());
        }
    }

    protected void setupDataProcessor(Agent agent, Process process, IExecutionHarnessDataProcessor dataProcessor) {
        dataProcessor.setControlAgent(agent);
        dataProcessor.setProcess(process);
        dataProcessor.init();
    }

    public boolean supportsControlEvent(String controlEvent) {
        return true;
    }

    protected int getLaunchTimeout() {
        return 60000;
    }

    protected void doLaunch(IProgressMonitor monitor) {
        super.launch(monitor);
    }
}

