/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderAgentEnvironmentAdapter;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderDataProcessor;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderExecutableObjectAdapter;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.local.IRecorderDataProcessor;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderEnvironmentAdapter;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderExecutableObjectAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HttpRecorderPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.hyades.execution.recorder.http";
    public static final String RECORDING_PATH = "recording_path";
    public static final String RECORDER_APP_ADAPTER = "application_under_test";
    public static final String PROXY_PORT = "default_proxy_port";
    public static final String DEFAULT_PORT = "1080";
    private static HttpRecorderPlugin plugin;
    private ResourceBundle resourceBundle;
    private Recorder recorder;

    public static void storePreference(String string, String string2) {
        HttpRecorderPlugin.getDefault().getPreferenceStore().setValue(string, string2);
    }

    private ResourceBundle getResourceBundle() {
        block2: {
            if (this.resourceBundle != null) break block2;
            try {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception exception) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static String getResourceString(String string) {
        return HttpRecorderPlugin.getDefault().getResourceBundle().getString(string);
    }

    public static String getPreference(String string) {
        return HttpRecorderPlugin.getDefault().getPreferenceStore().getString(string);
    }

    public static boolean getBoolPreference(String string) {
        return HttpRecorderPlugin.getDefault().getPreferenceStore().getBoolean(string);
    }

    public HttpRecorderPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        try {
            this.recorder = new Recorder(PLUGIN_ID, (IRecorderDataProcessor)new HttpRecorderDataProcessor(), (RecorderEnvironmentAdapter)new HttpRecorderAgentEnvironmentAdapter(), (RecorderExecutableObjectAdapter)new HttpRecorderExecutableObjectAdapter());
        }
        catch (RecorderException recorderException) {
            recorderException.printStackTrace();
        }
        this.initializeDefaultPreferences(this.getPreferenceStore());
    }

    public static HttpRecorderPlugin getDefault() {
        return plugin;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        if (Platform.getOS().equals("win32")) {
            iPreferenceStore.setDefault(RECORDER_APP_ADAPTER, "org.eclipse.hyades.execution.recorder.RecorderApplication.InternetExplorer");
        } else {
            iPreferenceStore.setDefault(RECORDER_APP_ADAPTER, "-1");
        }
        TestgenPlugin.getDefault().getPreferenceStore().setDefault("default_test_generator", TestgenPlugin.getDefault().getDefaultGeneratorID());
        iPreferenceStore.setDefault(PROXY_PORT, DEFAULT_PORT);
    }

    public static String getID() {
        return PLUGIN_ID;
    }
}

