/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class LoopDetailPage
extends DetailSection.DetailPage
implements ModifyListener,
SelectionListener {
    protected static final int HELP_PAGE_CONTROL = 1;
    protected static final int HELP_ITERATION_CONTROL = 2;
    protected static final int HELP_SYNCHRONOUS_CONTROL = 3;
    private Button synchronousButton;
    private StyledText iteractionsText;
    private ILoop loop;

    public void dispose() {
        this.loop = null;
    }

    public Control createControl(Composite composite, FormWidgetFactory formWidgetFactory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.synchronousButton = widgetFactory.createButton(composite2, this.getSynchronousLabel(), 32);
        this.synchronousButton.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite2, this.getIteractionsLabel());
        this.iteractionsText = widgetFactory.createStyledText(composite2, 65540);
        this.iteractionsText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.paintBordersFor(composite2);
        this.registerHelp(1, composite2);
        this.registerHelp(2, this.iteractionsText);
        this.registerHelp(3, this.synchronousButton);
        return composite2;
    }

    protected abstract String getSynchronousLabel();

    protected abstract String getIteractionsLabel();

    protected void registerHelp(int n, Object object) {
    }

    public void setInput(Object object) {
        Object object2;
        this.loop = null;
        this.synchronousButton.removeSelectionListener((SelectionListener)this);
        this.iteractionsText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.iteractionsText.removeModifyListener((ModifyListener)this);
        if (object instanceof IStructuredSelection && (object2 = (IStructuredSelection)object).size() == 1) {
            object = object2.getFirstElement();
        }
        if (object instanceof ILoop) {
            this.loop = (ILoop)object;
            object2 = this.loop.getCondition().getConstraint();
            if (object2 != null) {
                this.iteractionsText.setText((String)object2);
            } else {
                this.iteractionsText.setText("");
            }
            this.synchronousButton.setSelection(this.loop.isSynchronous());
            this.iteractionsText.setEditable(true);
        } else {
            this.synchronousButton.setEnabled(false);
            this.iteractionsText.setText("");
        }
        this.synchronousButton.addSelectionListener((SelectionListener)this);
        this.iteractionsText.addVerifyKeyListener((VerifyKeyListener)this);
        this.iteractionsText.addModifyListener((ModifyListener)this);
    }

    public Object getInput() {
        return this.loop;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        selectionEvent.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.isReadOnly()) {
            selectionEvent.doit = false;
        } else if (selectionEvent.widget == this.synchronousButton) {
            this.loop.setSynchronous(this.synchronousButton.getSelection());
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.iteractionsText) {
            this.loop.getCondition().setConstraint(this.iteractionsText.getText());
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        super.verifyKey(verifyEvent);
        UIUtil.integerStyledTextVerifyKey((VerifyEvent)verifyEvent);
    }
}

