/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.editor.action;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonImages;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.common.internal.editor.action.InsertBlockChildAction;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;

public abstract class InsertTestInvocation
extends InsertBlockChildAction {
    public InsertTestInvocation(IITestSuiteProvider iITestSuiteProvider, String string) {
        super(iITestSuiteProvider, TestCommonPlugin.getString("W_EVT_INV"), string);
        this.setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor("invocation.gif"));
    }

    public void run() {
        this.setActionPerformed(false);
        InvokedTestSelectionDialog invokedTestSelectionDialog = this.createInvokedTestSelectionDialog(this.getTestSuite());
        if (invokedTestSelectionDialog.open() == 0) {
            IBlock iBlock = null;
            EObject eObject = (EObject)this.getStructuredSelection().getFirstElement();
            EObject eObject2 = eObject.eContainer();
            iBlock = eObject2 != null && eObject2 instanceof IBlock ? (IBlock)eObject2 : this.getTestSuite().getImplementor().getBlock();
            if (iBlock != null) {
                Iterator iterator = invokedTestSelectionDialog.getTests().iterator();
                while (iterator.hasNext()) {
                    ITest iTest = (ITest)iterator.next();
                    ResourceSet resourceSet = ((EObject)this.getTestSuite()).eResource().getResourceSet();
                    iTest = (ITest)EMFUtil.getEObject((ResourceSet)resourceSet, (EObject)((EObject)iTest), (boolean)true);
                    ITestInvocation iTestInvocation = HyadesFactory.INSTANCE.createTestInvocation(iTest);
                    iTestInvocation.setName(this.calculateName(iTest));
                    iBlock.getActions().add(iTestInvocation);
                }
            }
            this.setActionPerformed(true);
        }
    }

    protected abstract InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite var1);

    protected String calculateName(ITest iTest) {
        String string = iTest.getName();
        if (string == null) {
            return TestCommonUtil.getUniqueName(this.getBaseName(), this.getBlock().getActions());
        }
        if (iTest instanceof ITestCase) {
            String string2;
            ITestSuite iTestSuite = ((ITestCase)iTest).getOwner();
            if (this.getTestSuite() != iTestSuite && (string2 = iTestSuite.getName()) != null) {
                string = string2 + "." + string;
            }
        }
        return TestCommonPlugin.getString("NME_CONCAT_SEP", new String[]{string, this.getBaseName()});
    }
}

