/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.wizard;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.common.internal.wizard.RunDestinationPage;
import org.eclipse.hyades.test.common.internal.wizard.RunLocationPage;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public abstract class RunWizard
extends Wizard
implements IWorkbenchWizard {
    protected static final String SET_DESTINATION = "SET_DESTINATION";
    protected static final String SET_LOCATION = "SET_LOCATION";
    protected RunDestinationPage destinationPage;
    protected RunLocationPage locationPage;
    protected IStructuredSelection selection;
    protected ResourceSet resourceSet;
    protected TPFTest test;

    public RunWizard() {
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("run_wiz.gif"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("RunWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("RunWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public void dispose() {
        this.test = null;
        if (this.resourceSet != null) {
            this.resourceSet.getResources().clear();
            this.resourceSet = null;
        }
        super.dispose();
    }

    public void createPageControls(Composite composite) {
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 400;
        gridData.widthHint = 450;
        composite.setLayoutData((Object)gridData);
        super.createPageControls(composite);
    }

    public void addPages() {
        String string;
        this.setWindowTitle(TestUIPlugin.getString((String)"RUN_WTITLE"));
        this.destinationPage = this.createDestionationPage();
        if (this.destinationPage != null) {
            this.addPage((IWizardPage)this.destinationPage);
            string = this.getDialogSettings().get(SET_DESTINATION + this.getTest().getId());
            if (string == null) {
                this.destinationPage.setInitialDestination(EMFUtil.getParent((Resource)this.getTest().eResource()));
            } else {
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
                if (iResource != null) {
                    if (iResource instanceof IContainer) {
                        this.destinationPage.setInitialDestination((IContainer)iResource);
                    } else {
                        this.destinationPage.setInitialDestination(iResource.getParent());
                    }
                }
            }
        }
        this.locationPage = this.createLocationPage();
        if (this.locationPage != null) {
            this.addPage((IWizardPage)this.locationPage);
            string = this.getDialogSettings().get(SET_LOCATION);
            if (string != null) {
                this.locationPage.setInitialLocationURI(URI.createURI((String)string));
            }
        }
    }

    protected String getExecutionResultInitialName() {
        StringBuffer stringBuffer = new StringBuffer(this.getTest().getName()).append("_");
        stringBuffer.append(DateFormat.getDateTimeInstance(2, 2).format(new Date()));
        return stringBuffer.toString();
    }

    protected RunDestinationPage createDestionationPage() {
        return new RunDestinationPage();
    }

    protected RunLocationPage createLocationPage() {
        return new RunLocationPage(true);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public TPFTest getTest() {
        return this.test;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        Object object;
        this.selection = iStructuredSelection;
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof TPFTest) {
            this.resourceSet = new ResourceSetImpl();
            this.test = (TPFTest)EMFUtil.getEObject((ResourceSet)this.resourceSet, (EObject)((TPFTest)object), (boolean)true);
            this.getTest().eResource().setTrackingModification(true);
        }
    }

    public String getExecutionResultName() {
        if (this.destinationPage == null) {
            return null;
        }
        return this.destinationPage.getExecutionResultName();
    }

    public IPath getContainerPath() {
        if (this.destinationPage == null) {
            return null;
        }
        return this.destinationPage.getContainerPath();
    }

    public TPFDeployment getDeployment() {
        if (this.locationPage == null) {
            return null;
        }
        return this.locationPage.getDeployment();
    }

    public BVRProperty[] getEnvironmentVariables() {
        CFGArtifact cFGArtifact;
        if (this.locationPage != null && (cFGArtifact = this.locationPage.getTestSuiteArtifact()) != null) {
            CFGPropertyGroup cFGPropertyGroup = ConfigurationUtil.searchPropertyGroupById((List)cFGArtifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
            Object object = cFGPropertyGroup.getProperties();
            object = EcoreUtil.copyAll((Collection)object);
            return object.toArray(new BVRProperty[object.size()]);
        }
        return new BVRProperty[0];
    }

    protected void saveSettings() {
        IPath iPath = this.getContainerPath();
        if (iPath != null) {
            this.getDialogSettings().put(SET_DESTINATION + this.getTest().getId(), this.getContainerPath().toString());
        }
        TPFDeployment tPFDeployment = this.getDeployment();
        CFGArtifactLocationPair cFGArtifactLocationPair = (CFGArtifactLocationPair)tPFDeployment.getArtifactLocations().get(0);
        CFGLocation cFGLocation = null;
        if (cFGArtifactLocationPair != null) {
            cFGLocation = cFGArtifactLocationPair.getLocation();
        }
        if (cFGLocation != null) {
            URI uRI = EcoreUtil.getURI((EObject)cFGLocation);
            this.getDialogSettings().put(SET_LOCATION, uRI.toString());
        }
    }

    public final boolean performFinish() {
        ITestSuite iTestSuite = null;
        if (this.getTest() instanceof ITestSuite) {
            iTestSuite = (ITestSuite)this.getTest();
        } else if (this.getTest() instanceof ITestCase) {
            iTestSuite = ((ITestCase)this.getTest()).getOwner();
        }
        if (this.locationPage != null && this.locationPage.getTestSuiteArtifact() != null) {
            List list = ((IDeployableComponent)iTestSuite).getEnvironmentVariables().getProperties();
            list.clear();
            list.addAll(Arrays.asList(this.getEnvironmentVariables()));
        }
        if (!this.doPerformFinish()) {
            return false;
        }
        this.saveSettings();
        SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong("saveInterval"));
        return true;
    }

    protected abstract boolean doPerformFinish();
}

