/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.adapter.PropertySourceLabelProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ListSection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.SelectionListenerAction;

public class DatapoolChildrenListSection
extends ListSection {
    private IAction[] buttonActions;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;

    public DatapoolChildrenListSection(EditorForm editorForm, IAction[] buttonActions, int listStyle) {
        super(editorForm);
        this.buttonActions = buttonActions;
        String[] buttonLabels = new String[buttonActions.length];
        int i = 0;
        while (i < buttonActions.length) {
            buttonLabels[i] = buttonActions[i].getText();
            ++i;
        }
        super.setButtonLabels(buttonLabels);
    }

    public void dispose() {
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                this.buttonActions[i] = null;
            }
            ++i;
        }
        super.dispose();
    }

    protected void adjustClient(Composite parent) {
        this.getListViewer().setContentProvider(this.getContentProvider());
        this.getListViewer().setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().setSelectionProvider((ISelectionProvider)this.getListViewer());
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                this.getViewerPart().setButtonEnabled(i, this.buttonActions[i].isEnabled());
            }
            ++i;
        }
    }

    protected IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new DatapoolChildrenContentProvider();
        }
        return this.contentProvider;
    }

    protected ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new PropertySourceLabelProvider();
        }
        return this.labelProvider;
    }

    protected Object[] getElements(IDatapool inputElement) {
        return new Object[0];
    }

    protected void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected void buttonSelected(int index) {
        if (!this.isReadOnly() && index >= 0 && index < this.buttonActions.length) {
            this.buttonActions[index].run();
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.buttonActions == null || this.buttonActions.length < 1) {
            return;
        }
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                if (this.buttonActions[i] instanceof SelectionListenerAction) {
                    ((SelectionListenerAction)this.buttonActions[i]).selectionChanged(structuredSelection);
                }
                this.getViewerPart().setButtonEnabled(i, this.buttonActions[i].isEnabled());
            }
            ++i;
        }
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
        super.selectionChanged(structuredSelection);
    }

    class DatapoolChildrenContentProvider
    implements IStructuredContentProvider {
        DatapoolChildrenContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IDatapool) {
                return DatapoolChildrenListSection.this.getElements((IDatapool)inputElement);
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            DatapoolChildrenListSection.this.inputChanged(viewer, oldInput, newInput);
        }

        public void dispose() {
        }
    }
}

