/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.adapter.INamedElementPropertySource;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySourceExtensionManager {
    private static PropertySourceExtensionManager instance;
    private static int executionEventIndex;
    private static int executionResultIndex;
    private static int testIndex;
    private static int testComponentIndex;
    private static int typedElementProxyIndex;
    private static String executionEventLiteral;
    private static String executionResultLiteral;
    private static String testLiteral;
    private static String testComponentLiteral;
    private static String typedElementProxyLiteral;
    private Map[] extensionContainer = new HashMap[5];

    public static PropertySourceExtensionManager getInstance() {
        if (instance == null) {
            instance = new PropertySourceExtensionManager();
        }
        return instance;
    }

    private PropertySourceExtensionManager() {
        int i = 0;
        while (i < 5) {
            this.extensionContainer[i] = new HashMap();
            ++i;
        }
        this.registerPropertySourceExtension();
    }

    private void registerPropertySourceExtension() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".propertySourceExtension");
        if (extPoint != null) {
            IConfigurationElement[] extensions = extPoint.getConfigurationElements();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] supportedTypes = extensions[i].getChildren();
                int j = 0;
                while (j < supportedTypes.length) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    int index = this.getIndexFromLiteral(kind);
                    if (index >= 0) {
                        this.extensionContainer[index].put(type, extensions[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private String getTypeFromObject(Object object) {
        if (object instanceof ITypedElementProxyNode) {
            return ((ITypedElementProxyNode)object).getType();
        }
        if (object instanceof TPFExecutionEvent) {
            return ((TPFExecutionEvent)object).getEventType();
        }
        if (object instanceof TPFExecutionResult) {
            return ((TPFExecutionResult)object).getType();
        }
        if (object instanceof TPFTest) {
            return ((TPFTest)object).getType();
        }
        if (object instanceof TPFTestComponent) {
            return ((TPFTestComponent)object).getType();
        }
        return null;
    }

    private int getIndexFromObject(Object object) {
        if (object instanceof ITypedElementProxyNode) {
            return typedElementProxyIndex;
        }
        if (object instanceof TPFExecutionEvent) {
            return executionEventIndex;
        }
        if (object instanceof TPFExecutionResult) {
            return executionResultIndex;
        }
        if (object instanceof TPFTest) {
            return testIndex;
        }
        if (object instanceof TPFTestComponent) {
            return testComponentIndex;
        }
        return -1;
    }

    private int getIndexFromLiteral(String kind) {
        if (typedElementProxyLiteral.equals(kind)) {
            return typedElementProxyIndex;
        }
        if (executionEventLiteral.equals(kind)) {
            return executionEventIndex;
        }
        if (executionResultLiteral.equals(kind)) {
            return executionResultIndex;
        }
        if (testLiteral.equals(kind)) {
            return testIndex;
        }
        if (testComponentLiteral.equals(kind)) {
            return testComponentIndex;
        }
        return -1;
    }

    public boolean isExtendableObject(Object object) {
        return object instanceof ITypedElementProxyNode || object instanceof TPFExecutionEvent || object instanceof TPFExecutionResult || object instanceof TPFTest || object instanceof TPFTestComponent;
    }

    public IPropertySource getPropertySource(Object object) {
        block7: {
            String type = this.getTypeFromObject(object);
            if (type == null) {
                return null;
            }
            int index = this.getIndexFromObject(object);
            if (index >= 0) {
                Object propertySource = this.extensionContainer[index].get(type);
                if (propertySource instanceof IConfigurationElement) {
                    IConfigurationElement configElem = (IConfigurationElement)propertySource;
                    INamedElementPropertySource pse = null;
                    try {
                        pse = (INamedElementPropertySource)configElem.createExecutableExtension("class");
                        if (pse != null) {
                            this.extensionContainer[index].put(type, pse);
                            return pse.getPropertySource(object);
                        }
                        break block7;
                    }
                    catch (CoreException e) {
                        TestUIPlugin.logError(e);
                        return null;
                    }
                }
                if (propertySource instanceof INamedElementPropertySource) {
                    return ((INamedElementPropertySource)propertySource).getPropertySource(object);
                }
            }
        }
        return null;
    }

    static {
        executionEventIndex = 0;
        executionResultIndex = 1;
        testIndex = 2;
        testComponentIndex = 3;
        typedElementProxyIndex = 4;
        executionEventLiteral = "executionEvent";
        executionResultLiteral = "executionResult";
        testLiteral = "test";
        testComponentLiteral = "testComponent";
        typedElementProxyLiteral = "typedElementProxy";
    }
}

