/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;

public class EditDatapoolAction
extends SelectionListenerAction {
    public EditDatapoolAction() {
        super(TestUIPlugin.getString("label.Update"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof DPLDatapool;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null) {
            return;
        }
        DPLDatapool datapool = (DPLDatapool)selection.getFirstElement();
        if (datapool == null) {
            return;
        }
        Resource resource = datapool.eResource();
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
            Path path = new Path(resource.getURI().toFileString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (!file.exists()) {
                return;
            }
            IEditorDescriptor desc = Workbench.getInstance().getEditorRegistry().getDefaultEditor(resource.getURI().toFileString());
            if (desc == null) {
                return;
            }
            page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

