/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class EMFContentProvider
implements ITreeContentProvider,
IDisposable {
    private TreeViewer treeViewer;
    private ResourceSet resourceSet;
    private Map elementDescriptionByFileExtension;
    private Map enabledChildrenByParentEClassifier;
    private boolean showEMFResource;
    private boolean showEnabledChildren;
    private ArrayList loadedEObjects;

    public EMFContentProvider(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.elementDescriptionByFileExtension = new HashMap();
        this.enabledChildrenByParentEClassifier = new HashMap();
        this.showEMFResource = false;
        this.loadedEObjects = new ArrayList();
    }

    public void dispose() {
        this.treeViewer = null;
        if (this.elementDescriptionByFileExtension != null) {
            this.elementDescriptionByFileExtension.clear();
            this.elementDescriptionByFileExtension = null;
        }
        if (this.enabledChildrenByParentEClassifier != null) {
            this.enabledChildrenByParentEClassifier.clear();
            this.enabledChildrenByParentEClassifier = null;
        }
        this.resourceSet = null;
        System.gc();
    }

    public void addElementDescription(ElementDescription elementDescription) {
        this.elementDescriptionByFileExtension.put(elementDescription.getFileExtension(), elementDescription);
    }

    public void removeElementDescription(ElementDescription elementDescription) {
        this.elementDescriptionByFileExtension.remove(elementDescription.getFileExtension());
    }

    public void addEnabledChildren(EnabledChildren enabledChildren) {
        this.enabledChildrenByParentEClassifier.put(enabledChildren.getParentEClassifier(), enabledChildren);
    }

    public void removeEnabledChildren(EnabledChildren enabledChildren) {
        this.enabledChildrenByParentEClassifier.remove(enabledChildren.getParentEClassifier());
    }

    public boolean isShowEMFResource() {
        return this.showEMFResource;
    }

    public void setShowEMFResource(boolean showEMFResource) {
        this.showEMFResource = showEMFResource;
    }

    public boolean isShowEnabledChildren() {
        return this.showEnabledChildren;
    }

    private boolean isChildrenEnabled(EObject parentObject) {
        EnabledChildren enabledChildren;
        return this.isShowEnabledChildren() && (enabledChildren = (EnabledChildren)this.enabledChildrenByParentEClassifier.get(parentObject.eClass())) != null;
    }

    public void setShowEnabledChildren(boolean showEnabledChildren) {
        this.showEnabledChildren = showEnabledChildren;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (TreeViewer)viewer;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof Resource) {
            return EMFUtil.getParent((Resource)element);
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            if (eObject.eContainer() != null) {
                return eObject.eContainer();
            }
            if (this.isShowEMFResource()) {
                return eObject.eResource();
            }
            return EMFUtil.getParent(eObject.eResource());
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        if (inputElement instanceof IWorkspaceRoot) {
            list.addAll(Arrays.asList(((IWorkspaceRoot)inputElement).getProjects()));
        }
        list.addAll(NavigatorExtensionUtil.getAllChildren((Object)inputElement, (String)"org.eclipse.hyades.test.ui.TestNavigator"));
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (NavigatorExtensionUtil.hasChildren((Object)element, (String)"org.eclipse.hyades.test.ui.TestNavigator")) {
            return true;
        }
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            if (!container.exists()) {
                return false;
            }
            IResource[] resources = null;
            try {
                resources = container.members();
                return resources != null && resources.length > 0;
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                return false;
            }
        }
        if (element instanceof Resource) {
            return !((Resource)element).getContents().isEmpty();
        }
        return element instanceof EObject && this.isChildrenEnabled((EObject)element);
    }

    public Object[] getChildren(Object parentElement) {
        EObject eObject;
        EnabledChildren enabledChildren;
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof IContainer) {
            IResource[] resources = null;
            try {
                resources = ((IContainer)parentElement).members();
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                children.addAll(NavigatorExtensionUtil.getAllChildren((Object)parentElement, (String)"org.eclipse.hyades.test.ui.TestNavigator"));
                return children.toArray();
            }
            int i = 0;
            int maxi = resources.length;
            while (i < maxi) {
                if (resources[i].getType() != 1) {
                    children.add(resources[i]);
                } else {
                    ElementDescription elementDescription;
                    String fileExtension = resources[i].getFileExtension();
                    if (fileExtension != null && (elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(fileExtension)) != null) {
                        EObject[] eObjects = EMFUtil.load(this.resourceSet, (IFile)resources[i]);
                        this.loadedEObjects.addAll(Arrays.asList(eObjects));
                        Iterator iter = elementDescription.getEClassifiers().iterator();
                        while (iter.hasNext()) {
                            Collection validObjects = EcoreUtil.getObjectsByType(Arrays.asList(eObjects), (EClassifier)((EClassifier)iter.next()));
                            if (this.isShowEMFResource()) {
                                Iterator iter2 = validObjects.iterator();
                                while (iter2.hasNext()) {
                                    children.add(((EObject)iter2.next()).eResource());
                                }
                                continue;
                            }
                            children.addAll(validObjects);
                        }
                    }
                }
                ++i;
            }
        } else if (parentElement instanceof Resource) {
            children.addAll((Collection<Object>)((Resource)parentElement).getContents());
        } else if (parentElement instanceof EObject && this.isShowEnabledChildren() && (enabledChildren = (EnabledChildren)this.enabledChildrenByParentEClassifier.get((eObject = (EObject)parentElement).eClass())) != null) {
            Iterator i = enabledChildren.getChildrenEStructuralFeatures().iterator();
            while (i.hasNext()) {
                Object child = eObject.eGet((EStructuralFeature)i.next(), false);
                if (child == null) continue;
                if (child instanceof Collection) {
                    children.addAll((Collection)child);
                    continue;
                }
                children.add(child);
            }
        }
        children.addAll(NavigatorExtensionUtil.getAllChildren((Object)parentElement, (String)"org.eclipse.hyades.test.ui.TestNavigator"));
        return children.toArray();
    }

    public List getLoadedEObjects() {
        return this.loadedEObjects;
    }

    public static class EnabledChildren {
        private EClassifier parentEClassifier;
        private List childrenEStructuralFeatures;

        public EnabledChildren(EClassifier parentEClassifier) {
            this.parentEClassifier = parentEClassifier;
        }

        public EClassifier getParentEClassifier() {
            return this.parentEClassifier;
        }

        public List getChildrenEStructuralFeatures() {
            if (this.childrenEStructuralFeatures == null) {
                this.childrenEStructuralFeatures = new UniqueEList();
            }
            return this.childrenEStructuralFeatures;
        }
    }

    public static class ElementDescription {
        private String fileExtension;
        private List eClassifiers;

        public ElementDescription(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public List getEClassifiers() {
            if (this.eClassifiers == null) {
                this.eClassifiers = new UniqueEList();
            }
            return this.eClassifiers;
        }
    }
}

