/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class TestDecoratingLabelProvider
extends DecoratingLabelProvider
implements ILabelProviderListener {
    private LinkedList listeners;
    private final TestNavigator testNavigator;

    public TestDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator, TestNavigator testNavigator) {
        super(provider, decorator);
        this.testNavigator = testNavigator;
        this.listeners = new LinkedList();
    }

    public void addListener(ILabelProviderListener listener) {
        ILabelDecorator decorator = this.getLabelDecorator();
        if (decorator != null) {
            decorator.addListener((ILabelProviderListener)this);
        }
        if (!this.listeners.contains(listener)) {
            ILabelProvider labelProvider = this.getLabelProvider();
            if (labelProvider != null) {
                labelProvider.addListener(listener);
            }
            this.listeners.add(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        ILabelDecorator decorator = this.getLabelDecorator();
        if (decorator != null) {
            decorator.removeListener((ILabelProviderListener)this);
        }
        if (this.listeners.contains(listener)) {
            ILabelProvider labelProvider = this.getLabelProvider();
            if (labelProvider != null) {
                labelProvider.removeListener(listener);
            }
            this.listeners.remove(listener);
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        Object[] elements = event.getElements();
        ArrayList<Object> others = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            Object elem = elements[i];
            if (elem instanceof IFile) {
                IFile file = (IFile)elem;
                if (file.exists()) {
                    Object convertedObject = FileProxyManager.getInstance().getProxy(file);
                    if (convertedObject == null) {
                        convertedObject = this.testNavigator.getConvertedObjectFromFile((IResource)file);
                    }
                    if (convertedObject != null) {
                        others.add(convertedObject);
                    } else {
                        others.add(elem);
                    }
                } else {
                    others.add(elem);
                }
            } else {
                others.add(elem);
            }
            ++i;
        }
        event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ILabelProviderListener l = (ILabelProviderListener)it.next();
            l.labelProviderChanged(event);
        }
    }
}

