/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;

public class TestResourceChangeUpdater
implements IResourceChangeUpdater {
    private TestNavigator testNavigator;
    private List addedObjects;
    private List removedObjects;
    private List changedObjects;
    private List resourcesToSave;
    private List expandedElements;
    private List selectedElements;
    private boolean active;

    public TestResourceChangeUpdater(TestNavigator testNavigator) {
        this.testNavigator = testNavigator;
        this.active = true;
    }

    public void dispose() {
        this.testNavigator = null;
    }

    public void started() {
        this.addedObjects = new UniqueEList();
        this.removedObjects = new UniqueEList();
        this.changedObjects = new UniqueEList();
        this.resourcesToSave = new UniqueEList();
    }

    public void ended() {
        Iterator i;
        if (!this.addedObjects.isEmpty()) {
            i = this.addedObjects.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                ITreeContentProvider treeContentProvider = (ITreeContentProvider)this.testNavigator.getViewer().getContentProvider();
                if (treeContentProvider != null) {
                    Object parent = treeContentProvider.getParent(object);
                    if (parent == null) {
                        this.testNavigator.getTreeViewer().refresh(true);
                        return;
                    }
                    this.testNavigator.getTreeViewer().add(parent, object);
                    continue;
                }
                return;
            }
        }
        if (!this.removedObjects.isEmpty() && !this.testNavigator.getTreeViewer().getControl().isDisposed()) {
            this.testNavigator.getTreeViewer().remove(this.removedObjects.toArray());
        }
        if (!this.changedObjects.isEmpty()) {
            i = this.changedObjects.iterator();
            while (i.hasNext()) {
                this.testNavigator.getTreeViewer().refresh(i.next(), true);
            }
        }
        if (!this.resourcesToSave.isEmpty()) {
            i = this.resourcesToSave.iterator();
            while (i.hasNext()) {
                try {
                    EMFUtil.save((Resource)i.next());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.addedObjects.clear();
        this.addedObjects = null;
        this.removedObjects.clear();
        this.removedObjects = null;
        this.changedObjects.clear();
        this.changedObjects = null;
        this.resourcesToSave.clear();
        this.resourcesToSave = null;
        if (this.expandedElements != null) {
            this.convertIdentifierToProxy(this.expandedElements);
            this.testNavigator.getTreeViewer().setExpandedElements(this.expandedElements.toArray());
            this.expandedElements = null;
        }
        if (this.selectedElements != null) {
            this.convertIdentifierToProxy(this.selectedElements);
            this.testNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.selectedElements), true);
            this.selectedElements = null;
        }
    }

    public boolean add(IResource parent, IResource[] affectedResources) {
        int i = 0;
        int maxi = affectedResources.length;
        while (i < maxi) {
            if (affectedResources[i].getType() != 1) {
                if (this.testNavigator.isVisibleResource(affectedResources[i])) {
                    this.addedObjects.add(affectedResources[i]);
                }
            } else {
                Object convertedObject = FileProxyManager.getInstance().getProxy((IFile)affectedResources[i]);
                if (convertedObject == null) {
                    convertedObject = this.testNavigator.getConvertedObjectFromFile(affectedResources[i]);
                }
                if (convertedObject == null) {
                    if (this.testNavigator.isVisibleResource(affectedResources[i])) {
                        this.addedObjects.add(affectedResources[i]);
                    }
                } else {
                    this.addedObjects.add(convertedObject);
                }
            }
            ++i;
        }
        return false;
    }

    public boolean remove(IResource parent, IResource[] affectedResources) {
        int i = 0;
        int maxi = affectedResources.length;
        while (i < maxi) {
            if (affectedResources[i].getType() != 1) {
                this.removedObjects.add(affectedResources[i]);
            } else {
                Object convertedObject;
                IProxyNode proxy;
                if (FileProxyManager.getInstance().isaKnownFile((IFile)affectedResources[i]) && (proxy = FileProxyManager.getInstance().removeProxy((IFile)affectedResources[i])) != null) {
                    this.removedObjects.add(proxy);
                }
                if ((convertedObject = this.testNavigator.getCorrespondingObjectFromFile(affectedResources[i])) == null) {
                    this.removedObjects.add(affectedResources[i]);
                } else {
                    this.removedObjects.add(convertedObject);
                    this.testNavigator.cleanConvertedObjectEntryFor(affectedResources[i]);
                    if (convertedObject instanceof EObject) {
                        Resource res = EMFUtil.getResource(null, (IFile)affectedResources[i]);
                        EMFUtil.remove(res);
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean replaced(IResource affectedResource) {
        return false;
    }

    public boolean updateProperties(IResource affectedResource) {
        if (affectedResource.getType() == 1) {
            Object[] eObjects = EMFUtil.getEObjects(null, (IFile)affectedResource);
            if (eObjects.length > 0) {
                this.testNavigator.getTreeViewer().update(eObjects, null);
            }
        } else {
            this.testNavigator.getTreeViewer().update((Object)affectedResource, null);
        }
        return false;
    }

    public boolean updateChildrenType(IResource affectedResource) {
        return false;
    }

    public boolean updateContent(IResource parent, IResource affectedResource) {
        IProxyNode proxy = FileProxyManager.getInstance().updateProxy((IFile)affectedResource);
        if (proxy != null) {
            this.changedObjects.add(proxy.getParent());
        } else {
            URI uri = this.getFileURI(affectedResource);
            if (uri != null) {
                EMFUtil.unloadIfNeeded(uri);
                Object convertedObject = this.testNavigator.getCorrespondingObjectFromFile(affectedResource);
                if (convertedObject != null) {
                    this.removedObjects.add(convertedObject);
                    this.testNavigator.cleanConvertedObjectEntryFor(affectedResource);
                    convertedObject = this.testNavigator.getConvertedObjectFromFile(affectedResource);
                    this.addedObjects.add(convertedObject);
                }
            }
        }
        if (this.changedObjects.size() > 0 && this.expandedElements == null) {
            this.expandedElements = new ArrayList();
            Object[] expObjects = this.testNavigator.getTreeViewer().getExpandedElements();
            int i = 0;
            while (i < expObjects.length) {
                this.expandedElements.add(expObjects[i]);
                ++i;
            }
            this.convertProxyToIdentifier(this.expandedElements);
            this.selectedElements = ((IStructuredSelection)this.testNavigator.getTreeViewer().getSelection()).toList();
            this.convertProxyToIdentifier(this.selectedElements);
        }
        return false;
    }

    public void setActive(boolean enable) {
        this.active = enable;
    }

    public boolean isActive() {
        return this.active;
    }

    protected URI getFileURI(IResource resource) {
        if (resource.getType() == 1) {
            String fileExtension = resource.getFileExtension();
            String[] files = this.testNavigator.getVisibleFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].equals(fileExtension)) {
                    return URI.createPlatformResourceURI((String)resource.getFullPath().toString());
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean isValid(EObject eObject) {
        return eObject instanceof CMNNamedElement;
    }

    private void convertProxyToIdentifier(List objects) {
        int i = 0;
        while (i < objects.size()) {
            if (objects.get(i) instanceof IProxyNode) {
                IProxyNode proxy = (IProxyNode)objects.get(i);
                objects.set(i, new ProxyIdentifier(proxy.getIdentifier(), proxy.getUnderlyingResource()));
            }
            ++i;
        }
    }

    private void convertIdentifierToProxy(List objects) {
        int i = 0;
        while (i < objects.size()) {
            if (objects.get(i) instanceof ProxyIdentifier) {
                IProxyNode proxy;
                ProxyIdentifier ident = (ProxyIdentifier)objects.get(i);
                IFile file = ident.getUnderlyingResource();
                String fragment = ident.getIdentifier();
                IProxyNode root = FileProxyManager.getInstance().getProxy(file);
                if (root != null && (proxy = FileProxyManager.getInstance().findProxyByID(root, fragment)) != null) {
                    objects.set(i, proxy);
                }
            }
            ++i;
        }
    }

    private void convertEObjectToURI(Object[] objects) {
        int i = 0;
        int maxi = objects.length;
        while (i < maxi) {
            if (objects[i] instanceof EObject) {
                objects[i] = EcoreUtil.getURI((EObject)((EObject)objects[i]));
            }
            ++i;
        }
    }

    private void convertURIToEObject(Object[] objects) {
        int i = 0;
        int maxi = objects.length;
        while (i < maxi) {
            if (objects[i] instanceof URI) {
                objects[i] = EMFUtil.getResourceSet().getEObject((URI)objects[i], false);
            }
            ++i;
        }
    }

    public void refreshContent(IResource affectedResource) {
        Control control = this.testNavigator.getTreeViewer().getControl();
        if (!control.isDisposed()) {
            this.testNavigator.getTreeViewer().refresh((Object)affectedResource);
        }
    }

    class ProxyIdentifier {
        private String identifier;
        private IFile underlyingResource;

        public ProxyIdentifier(String identifier, IFile file) {
            this.identifier = identifier;
            this.underlyingResource = file;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public IFile getUnderlyingResource() {
            return this.underlyingResource;
        }
    }
}

