/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyNodeTransfer;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyAction
extends Action
implements IDisposable {
    private Clipboard clipboard;
    private IStructuredSelection selection;

    public CopyAction(Clipboard clipboard) {
        super(TestUIPlugin.getString("command.Copy"));
        if (clipboard == null) {
            throw new IllegalArgumentException("Unable to perform copy action due to 'clipboard == null'");
        }
        this.clipboard = clipboard;
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
    }

    private void setClipboard() {
        try {
            this.clipboard.setContents(ClipboardManager.getInstance().getData(), ClipboardManager.getInstance().getTransfer());
        }
        catch (SWTError e) {
            if (e.code != 2002) {
                throw e;
            }
            TestUIPlugin.logError(e);
        }
    }

    private boolean copyResources() {
        if (this.selection.getFirstElement() instanceof IResource) {
            ClipboardManager.getInstance().clear();
            List selectedResources = this.selection.toList();
            Iterator it = selectedResources.iterator();
            while (it.hasNext()) {
                IResource res = (IResource)it.next();
                IPath location = res.getLocation();
                if (location != null) {
                    ClipboardManager.getInstance().addFile(location.toOSString());
                }
                ClipboardManager.getInstance().addText(res.getName());
                ClipboardManager.getInstance().addResource(res);
            }
            this.setClipboard();
            return true;
        }
        return false;
    }

    private boolean isAFileProxy(IProxyNode proxy) {
        return proxy instanceof FileProxyNode || proxy.getParent() instanceof IContainer;
    }

    private void copyProxies() {
        if (this.selection.getFirstElement() instanceof IProxyNode) {
            ClipboardManager.getInstance().clear();
            List proxies = this.selection.toList();
            Iterator it = proxies.iterator();
            while (it.hasNext()) {
                IProxyNode proxy = (IProxyNode)it.next();
                if (this.isAFileProxy(proxy)) {
                    IFile file = proxy.getUnderlyingResource();
                    IPath location = file.getLocation();
                    if (location != null) {
                        ClipboardManager.getInstance().addFile(location.toOSString());
                    }
                    ClipboardManager.getInstance().addResource((IResource)file);
                }
                ClipboardManager.getInstance().addText(proxy.getClass().getName() + "::" + proxy.getText());
                ClipboardManager.getInstance().addProxy(proxy);
            }
            this.setClipboard();
        }
    }

    public void run() {
        if (this.copyResources()) {
            return;
        }
        this.copyProxies();
    }

    private boolean selectionIsHomogeneous() {
        Object selItem = null;
        int flag = 0;
        int val = 0;
        Iterator it = this.selection.iterator();
        while (it.hasNext()) {
            selItem = it.next();
            if (selItem instanceof IProject) {
                val = 1;
            } else if (selItem instanceof IFolder) {
                val = 4;
            } else if (selItem instanceof IFile) {
                val = 8;
            } else if (selItem instanceof IProxyNode) {
                val = 16;
            } else {
                return false;
            }
            if (flag == 0) {
                flag = val;
                continue;
            }
            if ((flag ^= val) == 0) continue;
            return false;
        }
        return true;
    }

    private Object getParent(Object sel) {
        if (sel instanceof IResource) {
            IResource res = (IResource)sel;
            return res.getParent();
        }
        if (sel instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)sel;
            return proxy.getParent();
        }
        return null;
    }

    private boolean selectionHasSameParent() {
        Object firstParent = this.getParent(this.selection.getFirstElement());
        if (firstParent == null) {
            return false;
        }
        Iterator it = this.selection.iterator();
        while (it.hasNext()) {
            if (firstParent.equals(this.getParent(it.next()))) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableForSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        if (!this.selectionIsHomogeneous()) {
            return false;
        }
        return this.selectionHasSameParent();
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.selection = structuredSelection;
    }

    static class ClipboardManager {
        private Map clipboardContent = new HashMap();
        private static ClipboardManager instance;

        private ClipboardManager() {
        }

        public static ClipboardManager getInstance() {
            if (instance == null) {
                instance = new ClipboardManager();
            }
            return instance;
        }

        public void addText(String text) {
            String content = "";
            if (this.clipboardContent.containsKey(TextTransfer.getInstance())) {
                content = (String)this.clipboardContent.get(TextTransfer.getInstance());
                text = text + "\n";
            }
            content = content + text;
            this.clipboardContent.put(TextTransfer.getInstance(), content);
        }

        public void addFile(String fileName) {
            List<Object> fileNames = this.clipboardContent.containsKey(FileTransfer.getInstance()) ? Arrays.asList((Object[])this.clipboardContent.get(FileTransfer.getInstance())) : new LinkedList();
            LinkedList<String> tmp = new LinkedList<String>(fileNames);
            tmp.add(fileName);
            this.clipboardContent.put(FileTransfer.getInstance(), tmp.toArray(new String[tmp.size()]));
        }

        public void addResource(IResource res) {
            List<Object> resources = this.clipboardContent.containsKey(ResourceTransfer.getInstance()) ? Arrays.asList((Object[])this.clipboardContent.get(ResourceTransfer.getInstance())) : new LinkedList();
            LinkedList<IResource> tmp = new LinkedList<IResource>(resources);
            tmp.add(res);
            this.clipboardContent.put(ResourceTransfer.getInstance(), tmp.toArray(new IResource[tmp.size()]));
        }

        public void addProxy(IProxyNode proxy) {
            List<Object> proxies = this.clipboardContent.containsKey((Object)ProxyNodeTransfer.getInstance()) ? Arrays.asList((Object[])this.clipboardContent.get((Object)ProxyNodeTransfer.getInstance())) : new LinkedList();
            LinkedList<IProxyNode> tmp = new LinkedList<IProxyNode>(proxies);
            tmp.add(proxy);
            this.clipboardContent.put(ProxyNodeTransfer.getInstance(), tmp.toArray(new IProxyNode[tmp.size()]));
        }

        public Object[] getData() {
            Transfer[] transfers = this.getTransfer();
            Object[] data = new Object[transfers.length];
            int i = 0;
            while (i < transfers.length) {
                data[i] = this.clipboardContent.get(transfers[i]);
                ++i;
            }
            return data;
        }

        public Transfer[] getTransfer() {
            Set transfers = this.clipboardContent.keySet();
            return transfers.toArray(new Transfer[transfers.size()]);
        }

        public void clear() {
            this.clipboardContent.clear();
        }
    }
}

