/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.TestUISafeRunnable;
import org.eclipse.hyades.test.ui.internal.navigator.action.PasteAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.PasteExtensionManager;
import org.eclipse.hyades.test.ui.navigator.actions.IPaster;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends Action
implements IDisposable {
    protected Clipboard clipboard;
    private IStructuredSelection selection;
    private Shell shell;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(TestUIPlugin.getString("command.Paste"));
        if (shell == null) {
            throw new IllegalArgumentException("Unable to perform paste action due to 'shell == null'");
        }
        this.shell = shell;
        if (clipboard == null) {
            throw new IllegalArgumentException("Unable to perform paste action due to 'clipboard == null'");
        }
        this.clipboard = clipboard;
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
        this.shell = null;
    }

    public void run() {
        IResource[] res;
        boolean isProjectRes;
        Object target;
        Object object = target = this.selection != null ? this.selection.getFirstElement() : null;
        if (target != null) {
            IPaster[] pasters = PasteExtensionManager.getInstance().getPasters(target);
            int i = 0;
            while (i < pasters.length) {
                IPaster paster = pasters[i];
                class TestUISafeRunnableWithStatus
                extends TestUISafeRunnable {
                    private boolean isOk;
                    private final /* synthetic */ IPaster val$paster;
                    private final /* synthetic */ Object val$target;
                    private final /* synthetic */ PasteAction this$0;

                    TestUISafeRunnableWithStatus(PasteAction this$0, IPaster val$paster, Object val$target) {
                        this.this$0 = this$0;
                        this.val$paster = val$paster;
                        this.val$target = val$target;
                    }

                    public void run() throws Exception {
                        this.isOk = this.val$paster.isPasteAllowedFor(this.this$0.clipboard, this.val$target) && this.val$paster.performPaste(this.this$0.clipboard, this.val$target);
                    }

                    public boolean isOk() {
                        return this.isOk;
                    }
                }
                TestUISafeRunnableWithStatus runnable = new TestUISafeRunnableWithStatus(this, paster, target);
                Platform.run((ISafeRunnable)runnable);
                if (runnable.isOk()) {
                    return;
                }
                ++i;
            }
        }
        boolean bl = isProjectRes = (res = this.getResourceFromClipboard()) != null && res.length > 0 && res[0].getType() == 4;
        if (isProjectRes) {
            int i = 0;
            while (i < res.length) {
                CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                operation.copyProject((IProject)res[i]);
                ++i;
            }
        }
    }

    private IResource[] getResourceFromClipboard() {
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resTransfer);
            }
        });
        return clipboardData[0];
    }

    private boolean doesClipboardContainProjects() {
        boolean isProjectRes;
        IResource[] res = this.getResourceFromClipboard();
        boolean bl = isProjectRes = res != null && res.length > 0 && res[0].getType() == 4;
        if (isProjectRes) {
            int i = 0;
            while (i < res.length) {
                if (res[i].getType() != 4 || !((IProject)res[i]).isOpen()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isApplicableForSelection() {
        if (this.doesClipboardContainProjects()) {
            return true;
        }
        if (this.selection == null || this.selection.isEmpty() || this.selection.size() > 1) {
            return false;
        }
        return PasteExtensionManager.getInstance().isPasteAllowedFor(this.clipboard, this.selection.getFirstElement());
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.selection = structuredSelection;
    }
}

