/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.action.RenamerUIStatus;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class RenameAction
extends Action
implements IDisposable {
    private IStructuredSelection selection;
    protected Composite textEditorParent;
    private TreeEditor treeEditor;
    protected Tree navigatorTree;
    protected Text textEditor;
    private TextActionHandler textActionHandler;
    protected TreeNavigator navigator;
    protected IContainer renamedResource;
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer;

    public RenameAction(TreeNavigator treeNav) {
        super(IDEWorkbenchMessages.getString((String)"RenameResourceAction.text"));
        this.navigator = treeNav;
        this.navigatorTree = treeNav.getTreeViewer().getTree();
        this.treeEditor = new TreeEditor(this.navigatorTree);
        this.renamedResource = null;
    }

    public void dispose() {
        this.selection = null;
        this.disposeTextWidget();
    }

    public boolean isApplicableForSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        Object objSelected = this.selection.getFirstElement();
        if (objSelected instanceof IContainer) {
            return true;
        }
        if (objSelected instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)objSelected;
            IProxyNodeRenamer renamer = (IProxyNodeRenamer)proxy.getAdapter(class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer == null ? (class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer = RenameAction.class$("org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer")) : class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer);
            if (renamer != null) {
                return renamer.isApplicableFor();
            }
            return false;
        }
        return false;
    }

    private static int getCellEditorInset(Control c) {
        if ("carbon".equals(SWT.getPlatform()) && (System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") == null || c.getShell().getParent() != null)) {
            return -2;
        }
        return 1;
    }

    private Composite createParent() {
        Composite result = new Composite((Composite)this.navigatorTree, 0);
        TreeItem[] selectedItems = this.navigatorTree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void createTextEditor(final IProxyNodeRenamer renamer) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int inset = RenameAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = RenameAction.this.textEditor.getSize();
                    Point parentSize = RenameAction.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.navigatorTree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameAction.this.textEditorParent.getSize();
                RenameAction.this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                RenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameAction.this.performRename(renamer, RenameAction.this.textEditor.getText());
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameAction.this.disposeTextWidget();
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    protected void performRename(final IProxyNodeRenamer renamer, final String newName) {
        Runnable query = new Runnable(){

            public void run() {
                if (renamer == null) {
                    this.moveResource((IResource)RenameAction.this.renamedResource, newName);
                } else {
                    boolean shouldRefresh = renamer.performRename(newName);
                    if (shouldRefresh) {
                        RenameAction.this.navigator.getTreeViewer().refresh();
                    }
                }
                if (RenameAction.this.navigatorTree != null && !RenameAction.this.navigatorTree.isDisposed()) {
                    RenameAction.this.navigatorTree.setFocus();
                    TreeItem[] items = RenameAction.this.navigatorTree.getItems();
                    this.findItem(newName, items);
                }
            }

            private void moveResource(IResource res, String name) {
                IPath newPath = res.getFullPath().removeLastSegments(1).append(name);
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(this, res, newPath){
                    private final /* synthetic */ IResource val$res;
                    private final /* synthetic */ IPath val$newPath;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$res = val$res;
                        this.val$newPath = val$newPath;
                    }

                    public void execute(IProgressMonitor monitor) {
                        try {
                            this.val$res.move(this.val$newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorJobsDialog(Display.getCurrent().getActiveShell()).run(true, false, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {}
            }

            private boolean findItem(String name, TreeItem[] items) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].getText().equals(name)) {
                        RenameAction.this.navigator.selectReveal((ISelection)new StructuredSelection(items[i].getData()));
                        return true;
                    }
                    if (items[i].getItemCount() > 0 && this.findItem(name, items[i].getItems())) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        this.navigatorTree.getShell().getDisplay().asyncExec(query);
    }

    protected void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    private void getNewNameInline(String oldName, IProxyNodeRenamer renamer) {
        if (this.textEditorParent == null) {
            this.createTextEditor(renamer);
        }
        this.textEditor.setText(oldName);
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = RenameAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    public void run() {
        IProxyNode proxy;
        IProxyNodeRenamer renamer;
        Object objSelected = this.selection.getFirstElement();
        if (objSelected instanceof IContainer) {
            this.renamedResource = (IContainer)objSelected;
            this.getNewNameInline(((IContainer)objSelected).getName(), null);
        } else if (objSelected instanceof IProxyNode && (renamer = (IProxyNodeRenamer)(proxy = (IProxyNode)objSelected).getAdapter(class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer == null ? (class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer = RenameAction.class$("org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer")) : class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer)) != null) {
            RenamerUIStatus status = renamer.performUserInteraction(proxy.getText());
            switch (status.getStatus()) {
                case 0: {
                    this.performRename(renamer, status.getNewName());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.getNewNameInline(proxy.getText(), renamer);
                }
            }
        }
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.selection = structuredSelection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

