/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class DefaultTestSuiteProxyNode
extends TypedElementProxyNode
implements ITestSuiteProxyNode,
IPersistableProxyNode {
    private IAssociationDescriptor descriptor;
    private CMNNamedElementProxyNode[] testCases;

    public DefaultTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
        super((TPFTest)ts, parent);
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        this.descriptor = associationMapping.getDefaultAssociationDescriptor(ts.getType());
        LinkedList<IProxyNode> tcProxies = new LinkedList<IProxyNode>();
        EList testcases = ts.getTestCases();
        Iterator iter = testcases.iterator();
        while (iter.hasNext()) {
            TPFTestCase tc = (TPFTestCase)iter.next();
            IProxyNode proxy = HyadesProxyNodeFactory.getInstance().create((EObject)tc, this);
            if (proxy == null) continue;
            tcProxies.add(proxy);
        }
        this.testCases = tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);
    }

    public DefaultTestSuiteProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        this.descriptor = associationMapping.getDefaultAssociationDescriptor(this.getType());
        IMemento[] tcStates = memento.getChildren("childNode");
        LinkedList<IProxyNode> tcProxies = new LinkedList<IProxyNode>();
        int i = 0;
        while (i < tcStates.length) {
            IProxyNode proxy;
            IMemento mementoChild = tcStates[i];
            String type = mementoChild.getString("type");
            if (type == null) {
                throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field");
            }
            ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
            if (factory instanceof IPersistableTypedElementProxyFactory && (proxy = ((IPersistableTypedElementProxyFactory)factory).recreate(mementoChild, this)) != null) {
                tcProxies.add(proxy);
            }
            ++i;
        }
        this.testCases = tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);
    }

    public Image getImage() {
        if (this.descriptor == null) {
            return TestUIImages.INSTANCE.getImage("testsuite_obj.gif");
        }
        return this.descriptor.getImage();
    }

    public IProxyNode[] getChildren() {
        return this.testCases;
    }

    public TPFTestSuite getTestSuite() {
        EObject ts = EMFUtil.getResourceSet().getEObject(this.getOriginatorURI(), true);
        if (ts instanceof TPFTestSuite) {
            return (TPFTestSuite)ts;
        }
        return null;
    }

    public String getFactoryID() {
        return "EMFResourceProxyFactory";
    }

    public boolean saveState(IMemento memento) {
        memento.putString("nodeKind", "testSuiteNode");
        memento.putString("type", this.getType());
        memento.putString("name", this.getText());
        memento.putString("uri", this.getOriginatorURI().toString());
        int i = 0;
        while (i < this.testCases.length) {
            CMNNamedElementProxyNode tcProxy = this.testCases[i];
            if (tcProxy instanceof IPersistableProxyNode) {
                IMemento childMemento = memento.createChild("childNode");
                if (!((IPersistableProxyNode)((Object)tcProxy)).saveState(childMemento)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }
}

