/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;

public class FileFactoryManager {
    private static FileFactoryManager instance;
    private Map factories = new HashMap();
    private Map files = new HashMap();

    public static FileFactoryManager getInstance() {
        if (instance == null) {
            instance = new FileFactoryManager();
        }
        return instance;
    }

    private FileFactoryManager() {
        String extension;
        IConfigurationElement element;
        int i;
        IConfigurationElement[] members;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFileProxyFactory");
        if (extPoint != null) {
            members = extPoint.getConfigurationElements();
            i = 0;
            while (i < members.length) {
                element = members[i];
                if ("factory".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    this.addFactory(id, element);
                } else if ("file".equals(element.getName())) {
                    extension = element.getAttribute("extension");
                    String factoryID = element.getAttribute("factoryID");
                    if (extension != null && extension.length() != 0) {
                        this.addFile(extension, factoryID);
                    }
                }
                ++i;
            }
        }
        if ((extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFileFactory")) != null) {
            members = extPoint.getConfigurationElements();
            i = 0;
            while (i < members.length) {
                element = members[i];
                if ("file".equals(element.getName()) && (extension = element.getAttribute("extension")) != null && extension.length() != 0) {
                    String id = element.getAttribute("factory");
                    this.addFactory(id, element);
                    this.addFile(extension, id);
                }
                ++i;
            }
        }
    }

    private void addFactory(String id, IConfigurationElement element) {
        if (!this.factories.containsKey(id)) {
            this.factories.put(id, element);
        } else {
            TestUIPlugin.logInfo("ID: " + id + " already used in a previously registered factory");
        }
    }

    private void addFile(String extension, String id) {
        if (!this.files.containsKey(extension)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(id);
            this.files.put(extension, l);
        } else {
            ArrayList facID = (ArrayList)this.files.get(extension);
            if (!facID.contains(id)) {
                facID.add(id);
            }
        }
    }

    public ArrayList getFactories(String extension) {
        if (extension == null || extension.length() == 0) {
            return new ArrayList();
        }
        if (this.files.containsKey(extension)) {
            LinkedList<Integer> removed = new LinkedList<Integer>();
            ArrayList l = (ArrayList)this.files.get(extension);
            int i = 0;
            while (i < l.size()) {
                Object value = l.get(i);
                if (value instanceof String) {
                    IFileProxyFactory factory = this.getFactory((String)value);
                    if (factory != null) {
                        l.set(i, factory);
                    } else {
                        removed.add(new Integer(i));
                    }
                } else if (!(value instanceof IFileProxyFactory)) {
                    TestUIPlugin.logError("List of factories for file: " + extension + " contains something else than a factory");
                    removed.add(new Integer(i));
                }
                ++i;
            }
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                l.remove((Integer)it.next());
            }
            return l;
        }
        return new ArrayList();
    }

    public IFileProxyFactory getFactory(String id) {
        if (this.factories.containsKey(id)) {
            Object value = this.factories.get(id);
            if (value instanceof IConfigurationElement) {
                IConfigurationElement element = (IConfigurationElement)value;
                try {
                    IFileProxyFactory factory = element.getName().equals("file") ? (IFileProxyFactory)element.createExecutableExtension("factory") : (IFileProxyFactory)element.createExecutableExtension("class");
                    this.factories.put(id, factory);
                    return factory;
                }
                catch (CoreException e) {
                    this.factories.remove(id);
                    TestUIPlugin.logError("Enable to create the factory instance from configuration element");
                    return null;
                }
            }
            if (value instanceof IFileProxyFactory) {
                return (IFileProxyFactory)value;
            }
            TestUIPlugin.logError("Factory Id: " + id + " associated to something else than a factory");
            return null;
        }
        return null;
    }

    public boolean isRegistered(String fileExtension) {
        return this.files.containsKey(fileExtension);
    }
}

