/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class ReportWizardPage
extends WizardPage
implements Listener {
    private IReportGenerator reportGenerator;
    private IStructuredSelection selection;
    private Table reportTable;
    private Button openEditorCheckBox;

    public ReportWizardPage(String name, IStructuredSelection sel) {
        super(name);
        this.selection = sel;
        this.setTitle(TestUIPlugin.getString("WIZ_TST_REPP_PG_TTL"));
        this.setDescription(TestUIPlugin.getString("wizard.Report.NoDataPoolDefinition.Page"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        IPreferenceStore store = TestUIPlugin.getInstance().getPreferenceStore();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.reportTable = new Table(composite, 2308);
        this.reportTable.setLayoutData((Object)GridDataUtil.createFill());
        this.openEditorCheckBox = new Button(composite, 32);
        this.openEditorCheckBox.setText(TestUIPlugin.getString("REPORT_OPEN_EDITOR"));
        this.openEditorCheckBox.setSelection(store.getBoolean("OpenReportEditor"));
        this.openEditorCheckBox.setSelection(true);
        this.populateReportsTable();
        this.reportTable.addListener(13, (Listener)this);
        if (this.reportTable.getItemCount() > 0) {
            String reportName = this.getDialogSettings().get("LAST_REPORT");
            if (reportName != null) {
                TableItem[] items = this.reportTable.getItems();
                int i = 0;
                int maxi = items.length;
                while (i < maxi) {
                    if (reportName.equals(items[i].getText())) {
                        this.reportTable.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if (this.reportTable.getSelectionIndex() < 0) {
                this.reportTable.select(0);
            }
            Event event = new Event();
            event.widget = this.reportTable;
            event.item = this.reportTable.getSelection()[0];
            event.type = 13;
            this.handleEvent(event);
        }
        this.reportTable.setFocus();
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)(TestUIPlugin.getID() + ".rwiz0001"));
        WorkbenchHelp.setHelp((Control)this.openEditorCheckBox, (String)(TestUIPlugin.getID() + ".rwiz0002"));
        WorkbenchHelp.setHelp((Control)this.reportTable, (String)(TestUIPlugin.getID() + ".rwiz0003"));
    }

    public IReportGenerator getReportGenerator() {
        return this.reportGenerator;
    }

    public boolean openEditor() {
        return this.openEditorCheckBox.getSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleEvent(Event event) {
        this.setErrorMessage(null);
        switch (event.type) {
            case 13: {
                rep = this.getReportDescription();
                v0 = selectionOk = rep != null;
                if (!selectionOk) ** GOTO lbl21
                try {
                    this.reportGenerator = rep.getReportGenerator();
                }
                catch (Exception e) {
                    this.reportGenerator = null;
                    TestUIPlugin.logError(e);
                }
                finally {
                    if (this.reportGenerator == null) {
                        this.setErrorMessage(TestUIPlugin.getString("NO_INSTANCE_ERROR_"));
                        selectionOk = false;
                    }
                }
                this.setMessage(null);
                ** GOTO lbl22
lbl21:
                // 1 sources

                this.setMessage(TestUIPlugin.getString("NO_REPORT_SEL"));
lbl22:
                // 2 sources

                this.setPageComplete(selectionOk);
            }
        }
    }

    public static boolean isInternalWebBrowserAvailable() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorDescriptor[] editors = workbench.getEditorRegistry().getEditors("foo.html");
        int i = 0;
        while (i < editors.length) {
            if ("com.ibm.etools.webbrowser".equals(editors[i].getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ReportDescription getReportDescription() {
        int idx = this.reportTable.getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        Object obj = this.reportTable.getItem(idx).getData();
        if (obj instanceof ReportDescription) {
            return (ReportDescription)obj;
        }
        return null;
    }

    private void populateReportsTable() {
        this.reportTable.removeAll();
        ReportManager manager = TestUI.getReportManager();
        IReportDescription[] list = manager.getReportDescriptions();
        int idx = 0;
        while (idx < list.length) {
            ReportDescription data = (ReportDescription)list[idx];
            IReportGenerator gen = null;
            try {
                gen = data.getReportGenerator();
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (gen != null && gen.isAvailable((ISelection)this.selection)) {
                TableItem item = new TableItem(this.reportTable, 0);
                item.setText(data.getName());
                item.setData((Object)data);
                item.setImage(TestUIImages.INSTANCE.getImage("report_obj.gif"));
            }
            ++idx;
        }
    }
}

