/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.delegates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.delegates.AbstractLaunchConfigurationDelegate2;

public class BasicTestLaunchConfigurationDelegate2
extends AbstractLaunchConfigurationDelegate2 {
    protected TPFTest getLaunchedTest(ILaunchConfiguration configuration) throws CoreException {
        return TestLaunchConfigurationFacade.getTest(configuration, this.getResourceSet());
    }

    protected TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
        TPFDeployment depl = DeploymentLaunchConfigurationFacade.getDeployment(configuration, this.getResourceSet());
        if (depl != null) {
            return depl;
        }
        return null;
    }

    protected String getTestExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
        return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
    }

    protected IContainer getTestExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
        return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
    }

    protected boolean overrideExistingTestExecutionHistory(ILaunchConfiguration configuration) throws CoreException {
        return ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryOverriden(configuration);
    }

    protected Object getLaunchedElement(ILaunchConfiguration configuration) throws CoreException {
        return this.getLaunchedTest(configuration);
    }

    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
        IContainer tehLocation;
        String tehName;
        super.validate(configuration, mode);
        if (this.getDeployment(configuration) == null) {
            this.reportProblem("The configuration does not provide a Deployment");
        }
        if ((tehName = this.getTestExecutionHistoryName(configuration)) == null || tehName.equals("")) {
            this.reportProblem("The configuration does not provide a Test Execution History Name");
        }
        if ((tehLocation = this.getTestExecutionHistoryLocation(configuration)) == null) {
            this.reportProblem("The configuration does not provide a Test Execution History Location");
        } else if (!tehLocation.exists()) {
            this.reportProblem("The Test Execution History Location described by the configuration does not exist");
        }
    }

    public IExecutor invokeTestExecutionHarness(ILaunchConfiguration configuration, String mode, StringBuffer errorMessages, IProgressMonitor monitor) throws CoreException {
        TPFTest test = this.getLaunchedTest(configuration);
        TPFTestSuite testSuite = null;
        TPFTest subTest = null;
        if (test instanceof TPFTestCase) {
            subTest = test;
            testSuite = ((TPFTestCase)subTest).getTestSuite();
        } else if (test instanceof TPFTestSuite) {
            testSuite = (TPFTestSuite)test;
            subTest = test;
        }
        TPFDeployment deployment = this.getDeployment(configuration);
        String tehName = this.getTestExecutionHistoryName(configuration);
        String tehLocation = this.getTestExecutionHistoryLocation(configuration).getFullPath().toString();
        boolean overrideExistingExecHistory = this.overrideExistingTestExecutionHistory(configuration);
        String port = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
        TestExecutionHarness teh = new TestExecutionHarness();
        IExecutor executor = teh.launchTest((ITestSuite)testSuite, (ITest)subTest, deployment, port, tehLocation, tehName, overrideExistingExecHistory, true, false, errorMessages, monitor);
        if (!monitor.isCanceled()) {
            SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong("saveInterval"));
        }
        return executor;
    }
}

