/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.action.RenamerUIStatus;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public abstract class FileProxyNode
implements IProxyNode,
IProxyNodeRenamer {
    protected IFile file;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer;

    public FileProxyNode(IFile file) {
        this.file = file;
    }

    public String getText() {
        return this.file.getName();
    }

    public Image getImage() {
        SharedImages images = new SharedImages();
        return images.getImage("IMG_OBJ_FILE");
    }

    public Object getParent() {
        return this.file.getParent();
    }

    public IFile getFile() {
        return this.file;
    }

    public IProxyNode[] getChildren() {
        return new IProxyNode[0];
    }

    public String getIdentifier() {
        return "";
    }

    public IFile getUnderlyingResource() {
        return this.file;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = FileProxyNode.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource) && this.getParent() instanceof IContainer) {
            return this.file;
        }
        if (adapter == (class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer == null ? (class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer = FileProxyNode.class$("org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer")) : class$org$eclipse$hyades$test$ui$navigator$actions$IProxyNodeRenamer)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isApplicableFor() {
        return true;
    }

    public boolean performRename(String newName) {
        block5: {
            if (newName.equals(this.file.getName())) break block5;
            IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
            IStatus status = workspace.validateName(newName, this.file.getType());
            if (!status.isOK()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)HyadesUIPlugin.getString((String)"W_ERROR"), (String)status.getMessage());
            } else {
                final IPath newPath = this.file.getFullPath().removeLastSegments(1).append(newName);
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            FileProxyNode.this.file.move(newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorJobsDialog(Display.getCurrent().getActiveShell()).run(true, false, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {}
            }
        }
        return false;
    }

    public RenamerUIStatus performUserInteraction(String oldName) {
        return new RenamerUIInlineEditor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

