/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class ProxyNodeTransfer
extends ByteArrayTransfer {
    private static final ProxyNodeTransfer instance = new ProxyNodeTransfer();
    private static final String TYPE_NAME = "proxy-transfer-format" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = Transfer.registerType((String)TYPE_NAME);

    public static ProxyNodeTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    private void writeProxy(DataOutputStream dataOut, IProxyNode proxy) throws IOException {
        dataOut.writeUTF(proxy.getUnderlyingResource().getLocation().toOSString());
        dataOut.writeUTF(proxy.getIdentifier());
    }

    private IProxyNode readProxy(DataInputStream dataIn) throws IOException {
        String fileName = dataIn.readUTF();
        String identifier = dataIn.readUTF();
        return FileProxyManager.getInstance().getCorrespondingProxy(fileName, identifier);
    }

    protected void javaToNative(Object object, TransferData transferData) {
        Object[] proxies = (Object[])object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(proxies.length);
            int i = 0;
            while (i < proxies.length) {
                this.writeProxy(out, (IProxyNode)proxies[i]);
                ++i;
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            IProxyNode[] proxies = new IProxyNode[n];
            int i = 0;
            while (i < n) {
                IProxyNode proxy = this.readProxy(in);
                if (proxy == null) {
                    return null;
                }
                proxies[i] = proxy;
                ++i;
            }
            return proxies;
        }
        catch (IOException e) {
            return null;
        }
    }
}

